/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

public class CoreModule
implements Module {
    public static final CoreModule INSTANCE = new CoreModule();
    private final Map<String, BuiltInFunctionDefinition> normalizedFunctions;
    private final Set<String> functionNamesWithInternal;
    private final Set<String> functionNamesWithoutInternal;

    private CoreModule() {
        List<BuiltInFunctionDefinition> definitions = BuiltInFunctionDefinitions.getDefinitions();
        this.normalizedFunctions = definitions.stream().collect(Collectors.toMap(f -> f.getName().toUpperCase(Locale.ROOT), Function.identity()));
        this.functionNamesWithInternal = definitions.stream().map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
        this.functionNamesWithoutInternal = definitions.stream().filter(f -> !f.isInternal()).map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> listFunctions() {
        return this.listFunctions(false);
    }

    @Override
    public Set<String> listFunctions(boolean includeHiddenFunctions) {
        if (includeHiddenFunctions) {
            return this.functionNamesWithInternal;
        }
        return this.functionNamesWithoutInternal;
    }

    @Override
    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        String normalizedName = name.toUpperCase(Locale.ROOT);
        return Optional.ofNullable(this.normalizedFunctions.get(normalizedName));
    }
}

