/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

public class ListMemorySegmentPool
implements MemorySegmentPool {
    private final List<MemorySegment> segments;
    private final int pageSize;

    public ListMemorySegmentPool(List<MemorySegment> memorySegments) {
        this.segments = memorySegments;
        this.pageSize = this.segments.get(0).size();
    }

    @Override
    public MemorySegment nextSegment() {
        if (this.segments.size() > 0) {
            return this.segments.remove(this.segments.size() - 1);
        }
        return null;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.segments.addAll(memory);
    }

    @Override
    public int freePages() {
        return this.segments.size();
    }

    public void clear() {
        this.segments.clear();
    }
}

