/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import com.healthmarketscience.rmiio.RemoteIterator;
import com.healthmarketscience.rmiio.RemoteIteratorServer;
import com.healthmarketscience.rmiio.RemoteRetry;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteIteratorClient<DataType>
implements RemoteIterator<DataType>,
Serializable {
    private static final long serialVersionUID = -7068967719628663585L;
    private final RemoteInputStream _remoteIStream;
    private transient InputStream _localIStream;
    private transient boolean _initialized;
    private transient boolean _hasNext;
    private transient DataType _nextObj;
    private transient RemoteRetry _remoteRetry;

    protected RemoteIteratorClient(RemoteIteratorServer<DataType> server) throws IOException {
        this(server, null);
    }

    protected RemoteIteratorClient(RemoteIteratorServer<DataType> server, RemoteStreamExporter exporter) throws IOException {
        this._remoteIStream = server.getRemoteInputStream(exporter);
    }

    @Override
    public void setRemoteRetry(RemoteRetry newRemoteRetry) {
        this._remoteRetry = newRemoteRetry;
    }

    private void initialize() throws IOException {
        if (!this._initialized) {
            try {
                this._initialized = true;
                this._hasNext = true;
                this._localIStream = RemoteInputStreamClient.wrap(this._remoteIStream, this._remoteRetry);
                this.initialize(this._localIStream);
                this.doRead();
            }
            catch (EOFException e) {
                this.closeImpl();
            }
        }
    }

    private void doRead() throws IOException {
        try {
            this._nextObj = this.readNextObject();
        }
        catch (EOFException e) {
            this.closeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() throws IOException {
        if (this._hasNext) {
            this._hasNext = false;
            try {
                this.closeIterator();
            }
            finally {
                if (this._localIStream != null) {
                    this._localIStream.close();
                }
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        this.initialize();
        return this._hasNext;
    }

    @Override
    public DataType next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DataType curObj = this._nextObj;
        this.doRead();
        return curObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.initialize();
        }
        finally {
            this.closeImpl();
        }
    }

    protected void closeIterator() throws IOException {
    }

    protected abstract void initialize(InputStream var1) throws IOException;

    protected abstract DataType readNextObject() throws IOException;
}

