/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IndexProtocol;

public class IndexInfo {
    private final CompiledValue _key;
    final CompiledValue _path;
    final int _operator;
    final IndexProtocol _index;
    final int _matchLevel;
    final int[] mapping;

    IndexInfo(CompiledValue key, CompiledValue path, IndexProtocol index, int matchLevel, int[] mapping, int op) {
        this._key = key;
        this._path = path;
        this._operator = op;
        this._index = index;
        this._matchLevel = matchLevel;
        this.mapping = mapping;
    }

    Object evaluateIndexKey(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (((AbstractIndex)this._index).isMapType()) {
            CompiledValue mapKey = ((MapIndexable)((Object)this._path)).getMapLookupKey();
            return new Object[]{this._key.evaluate(context), mapKey.evaluate(context)};
        }
        return this._key.evaluate(context);
    }

    public CompiledValue _key() {
        return this._key;
    }

    public CompiledValue _path() {
        return this._path;
    }

    public int _operator() {
        return this._operator;
    }

    public IndexProtocol _getIndex() {
        return this._index;
    }
}

