/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.util.Arrays;

public enum ExitCode {
    DEPENDENCY_GRAPH_FAILURE(-1),
    NORMAL(0),
    FATAL(1),
    INSTALL_FAILURE(2),
    JVM_TERMINATED_EXIT(99);

    private final int shellReturnValue;

    private ExitCode(int shellReturnValue) {
        this.shellReturnValue = shellReturnValue;
    }

    public int getValue() {
        return this.shellReturnValue;
    }

    public void doSystemExit() {
        System.exit(this.shellReturnValue);
    }

    public static ExitCode fromValue(int i) {
        return Arrays.stream(ExitCode.values()).filter(c -> c.getValue() == i).findFirst().orElseThrow(() -> new IllegalArgumentException("No ExitCode exists with shell exit value: " + i));
    }
}

