/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.BaseDecoratorImpl;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class NumberThresholdDecoratorImpl
extends BaseDecoratorImpl
implements DataSerializableFixedID {
    private static final long serialVersionUID = -1799140125261894306L;
    protected Number threshold;
    protected boolean evalForGtThan;
    public static final String ID = "NumberThreshold";

    public NumberThresholdDecoratorImpl() {
    }

    public NumberThresholdDecoratorImpl(StatAlertDefinition definition, Number threshold, boolean evalForGtThan) {
        super(definition);
        this.threshold = threshold;
        this.evalForGtThan = evalForGtThan;
    }

    public int getDSFID() {
        return 1073;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public boolean isGauge() {
        return false;
    }

    public boolean isEvalForGreaterThan() {
        return this.evalForGtThan;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        return super.verify(factory) && null != this.threshold;
    }

    @Override
    public String toString() {
        return super.toString() + "Threshold Value:" + this.threshold + "\n";
    }

    @Override
    public boolean evaluate(Number[] params) {
        if (this.evalForGtThan) {
            return super.evaluate(params) && NumberThresholdDecoratorImpl.isGreaterThan(this.getValue(params)[0], this.threshold);
        }
        return super.evaluate(params) && NumberThresholdDecoratorImpl.isLessThan(this.getValue(params)[0], this.threshold);
    }

    @Override
    public boolean evaluate() {
        return this.evaluate(this.getValue());
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate(params) ? super.evaluateAndAlert(params) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? super.evaluateAndAlert() : null;
    }

    @Override
    public Number[] getValue() {
        return super.getValue();
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return super.getValue(vals);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) || super.hasDecorator(decoratorID);
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) ? this : super.getDecorator(decoratorID);
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out);
        context.getSerializer().writeObject((Object)this.threshold, out);
        DataSerializer.writePrimitiveBoolean(this.evalForGtThan, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.threshold = (Number)context.getDeserializer().readObject(in);
        this.evalForGtThan = DataSerializer.readPrimitiveBoolean(in);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

