/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalEntryEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.lang.SystemProperty;
import org.apache.geode.pdx.internal.InternalPdxInstance;

public class EntryEventSerialization {
    private final boolean enabled = SystemProperty.getProductBooleanProperty((String)"earlyEntryEventSerialization").orElse(false);

    public void serializeNewValueIfNeeded(InternalRegion region, InternalEntryEvent event) {
        if (this.enabled) {
            this.doWork(region, event);
        }
    }

    private void doWork(InternalRegion region, InternalEntryEvent event) {
        if (region.getScope().isLocal()) {
            return;
        }
        if (region instanceof HARegion) {
            return;
        }
        if (region instanceof BucketRegionQueue) {
            return;
        }
        if (event.getCachedSerializedNewValue() != null) {
            return;
        }
        Object newValue = event.basicGetNewValue();
        if (newValue == null) {
            return;
        }
        if (newValue instanceof byte[]) {
            return;
        }
        if (Token.isToken(newValue)) {
            return;
        }
        event.setCachedSerializedNewValue(this.toBytes(newValue));
    }

    private byte[] toBytes(Object newValue) {
        byte[] newValueBytes = newValue instanceof InternalPdxInstance ? this.toBytes((InternalPdxInstance)newValue) : (newValue instanceof CachedDeserializable ? this.toBytes((CachedDeserializable)newValue) : EntryEventImpl.serialize(newValue));
        return newValueBytes;
    }

    private byte[] toBytes(InternalPdxInstance pdxInstance) {
        try {
            return pdxInstance.toBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private byte[] toBytes(CachedDeserializable cachedDeserializable) {
        return cachedDeserializable.getSerializedValue();
    }
}

