/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;

public class PartitionRegionInfoImpl
implements InternalPRInfo,
Serializable {
    private static final long serialVersionUID = 6462414089469761476L;
    private final String regionPath;
    private final int configuredBucketCount;
    private final int createdBucketCount;
    private final int lowRedundancyBucketCount;
    private final int configuredRedundantCopies;
    private final int actualRedundantCopies;
    private final Set<InternalPartitionDetails> memberDetails;
    private final String colocatedWith;
    private final OfflineMemberDetails offlineMembers;

    public PartitionRegionInfoImpl(String regionPath, int configuredBucketCount, int createdBucketCount, int lowRedundancyBucketCount, int configuredRedundantCopies, int actualRedundantCopies, Set<InternalPartitionDetails> memberDetails, String colocatedPath, OfflineMemberDetails offlineMembers) {
        this.regionPath = regionPath;
        this.configuredBucketCount = configuredBucketCount;
        this.createdBucketCount = createdBucketCount;
        this.lowRedundancyBucketCount = lowRedundancyBucketCount;
        this.configuredRedundantCopies = configuredRedundantCopies;
        this.actualRedundantCopies = actualRedundantCopies;
        this.memberDetails = memberDetails;
        this.colocatedWith = colocatedPath;
        this.offlineMembers = offlineMembers;
    }

    @Override
    public int getActualRedundantCopies() {
        return this.actualRedundantCopies;
    }

    @Override
    public String getColocatedWith() {
        return this.colocatedWith;
    }

    @Override
    public int getConfiguredBucketCount() {
        return this.configuredBucketCount;
    }

    @Override
    public int getConfiguredRedundantCopies() {
        return this.configuredRedundantCopies;
    }

    @Override
    public int getCreatedBucketCount() {
        return this.createdBucketCount;
    }

    @Override
    public int getLowRedundancyBucketCount() {
        return this.lowRedundancyBucketCount;
    }

    @Override
    public Set<PartitionMemberInfo> getPartitionMemberInfo() {
        return Collections.unmodifiableSet(this.memberDetails);
    }

    @Override
    public Set<InternalPartitionDetails> getInternalPartitionDetails() {
        return Collections.unmodifiableSet(this.memberDetails);
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public OfflineMemberDetails getOfflineMembers() {
        return this.offlineMembers;
    }

    public String toString() {
        return "[PartitionRegionInfoImpl: regionPath=" + this.regionPath + ", configuredBucketCount=" + this.configuredBucketCount + ", createdBucketCount=" + this.createdBucketCount + ", lowRedundancyBucketCount=" + this.lowRedundancyBucketCount + ", configuredRedundantCopies=" + this.configuredRedundantCopies + ", actualRedundantCopies=" + this.actualRedundantCopies + ", memberDetails=" + this.memberDetails + ", colocatedWith=" + this.colocatedWith + ", offlineMembers=" + this.offlineMembers + "]";
    }

    public int hashCode() {
        return this.regionPath.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionRegionInfoImpl)) {
            return false;
        }
        PartitionRegionInfoImpl o = (PartitionRegionInfoImpl)other;
        return this.regionPath.equals(o.regionPath);
    }

    @Override
    public int compareTo(InternalPRInfo other) {
        return this.regionPath.compareTo(other.getRegionPath());
    }
}

