/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public class CanonicalIdHolder {
    private final Int2ObjectOpenHashMap<Object> idToObject = new Int2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<Object> objectToID = new Object2IntOpenHashMap();
    private int highestID = 0;

    public void addMapping(int id, Object object) {
        this.idToObject.put(id, object);
        this.objectToID.put(object, id);
        this.highestID = Math.max(this.highestID, id);
    }

    public int getId(Object object) {
        return this.objectToID.getInt(object);
    }

    public Object getObject(int id) {
        return this.idToObject.get(id);
    }

    public int createId(Object object) {
        assert (!this.objectToID.containsKey(object));
        int id = ++this.highestID;
        this.objectToID.put(object, id);
        this.idToObject.put(id, object);
        return id;
    }

    public Int2ObjectOpenHashMap<Object> getAllMappings() {
        return this.idToObject;
    }
}

