/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateLuceneCommandParametersValidator {
    public static void validateRegionName(String name) {
        CreateLuceneCommandParametersValidator.validateNameNotEmptyOrNull(name);
        String msg = "Region names may only be alphanumeric, must not begin with double-underscores, but can contain hyphens, underscores, or forward slashes: ";
        Matcher matcher = Pattern.compile("[aA-zZ0-9-_./]+").matcher(name);
        if (name.startsWith("__") || name.startsWith("/__") || !matcher.matches()) {
            throw new IllegalArgumentException(msg + name);
        }
    }

    public static void validateLuceneIndexName(String name) {
        CreateLuceneCommandParametersValidator.validateNameNotEmptyOrNull(name);
        String msg = "Index names may only be alphanumeric, must not begin with double-underscores, but can contain hyphens or underscores: ";
        Matcher matcher = Pattern.compile("[aA-zZ0-9-_.]+").matcher(name);
        if (name.startsWith("__") || !matcher.matches()) {
            throw new IllegalArgumentException(msg + name);
        }
    }

    private static void validateNameNotEmptyOrNull(String nameProvided) {
        if (nameProvided == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (nameProvided.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
    }
}

