/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.codec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.geronimo.mail.james.mime4j.codec.Base64InputStream;
import org.apache.geronimo.mail.james.mime4j.codec.DecodeMonitor;
import org.apache.geronimo.mail.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.geronimo.mail.james.mime4j.io.InputStreams;
import org.apache.geronimo.mail.james.mime4j.util.ByteArrayBuffer;
import org.apache.geronimo.mail.james.mime4j.util.CharsetUtil;

public class DecoderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decodeQuotedPrintable(String s, DecodeMonitor monitor) {
        byte[] byArray;
        QuotedPrintableInputStream is = new QuotedPrintableInputStream(InputStreams.createAscii(s), monitor);
        try {
            int b;
            ByteArrayBuffer buf = new ByteArrayBuffer(s.length());
            while ((b = is.read()) != -1) {
                buf.append(b);
            }
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        is.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decodeBase64(String s, DecodeMonitor monitor) {
        byte[] byArray;
        Base64InputStream is = new Base64InputStream(InputStreams.createAscii(s), monitor);
        try {
            int b;
            ByteArrayBuffer buf = new ByteArrayBuffer(s.length());
            while ((b = is.read()) != -1) {
                buf.append(b);
            }
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        is.close();
        return byArray;
    }

    static String decodeB(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        byte[] decodedBytes = DecoderUtil.decodeBase64(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeQ(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        encodedText = DecoderUtil.replaceUnderscores(encodedText);
        byte[] decodedBytes = DecoderUtil.decodeQuotedPrintable(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeEncodedWords(String body) {
        return DecoderUtil.decodeEncodedWords(body, DecodeMonitor.SILENT);
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor) throws IllegalArgumentException {
        return DecoderUtil.decodeEncodedWords(body, monitor, null, Collections.emptyMap());
    }

    public static String decodeEncodedWords(String body, Charset fallback) throws IllegalArgumentException {
        return DecoderUtil.decodeEncodedWords(body, null, fallback, Collections.emptyMap());
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor, Charset fallback) throws IllegalArgumentException {
        return DecoderUtil.decodeEncodedWords(body, monitor, fallback, Collections.emptyMap());
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor, Charset fallback, Map<Charset, Charset> charsetOverrides) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        while (position < body.length()) {
            int startPattern = body.indexOf("=?", position);
            if (startPattern < 0) {
                if (position == 0) {
                    return body;
                }
                sb.append(body, position, body.length());
                break;
            }
            int charsetEnd = body.indexOf(63, startPattern + 2);
            int encodingEnd = body.indexOf(63, charsetEnd + 1);
            int encodedTextEnd = body.indexOf("?=", encodingEnd + 1);
            if (charsetEnd < 0 || encodingEnd < 0 || encodedTextEnd < 0) {
                sb.append(body, position, startPattern + 2);
                position = startPattern + 2;
                continue;
            }
            if (encodingEnd == encodedTextEnd) {
                sb.append(body, position, Math.min(encodedTextEnd + 2, body.length()));
                position = encodedTextEnd + 2;
                continue;
            }
            String separator = body.substring(position, startPattern);
            if (!(CharsetUtil.isWhitespace(separator) && position != 0 || separator.isEmpty())) {
                sb.append(separator);
            }
            String mimeCharset = body.substring(startPattern + 2, charsetEnd);
            String encoding = body.substring(charsetEnd + 1, encodingEnd);
            String encodedText = body.substring(encodingEnd + 1, encodedTextEnd);
            if (encodedText.isEmpty()) {
                position = encodedTextEnd + 2;
                continue;
            }
            String decoded = DecoderUtil.tryDecodeEncodedWord(mimeCharset, encoding, encodedText, monitor, fallback, charsetOverrides);
            if (decoded != null) {
                if (!CharsetUtil.isWhitespace(decoded) && !decoded.isEmpty()) {
                    sb.append(decoded);
                }
            } else {
                sb.append(body, startPattern, encodedTextEnd + 2);
            }
            position = encodedTextEnd + 2;
        }
        return sb.toString();
    }

    private static String tryDecodeEncodedWord(String mimeCharset, String encoding, String encodedText, DecodeMonitor monitor, Charset fallback, Map<Charset, Charset> charsetOverrides) {
        Charset charset = DecoderUtil.lookupCharset(mimeCharset, fallback, charsetOverrides);
        if (charset == null) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Mime charser '", mimeCharset, "' doesn't have a corresponding Java charset");
            return null;
        }
        if (encodedText.length() == 0) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Missing encoded text in encoded word");
            return null;
        }
        try {
            if (encoding.equalsIgnoreCase("Q")) {
                return DecoderUtil.decodeQ(encodedText, charset.name(), monitor);
            }
            if (encoding.equalsIgnoreCase("B")) {
                return DecoderUtil.decodeB(encodedText, charset.name(), monitor);
            }
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Warning: Unknown encoding in encoded word");
            return null;
        }
        catch (UnsupportedEncodingException e) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Unsupported encoding (", e.getMessage(), ") in encoded word");
            return null;
        }
        catch (RuntimeException e) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Could not decode (", e.getMessage(), ") encoded word");
            return null;
        }
    }

    private static Charset lookupCharset(String mimeCharset, Charset fallback, Map<Charset, Charset> charsetOverrides) {
        Charset charset = CharsetUtil.lookup(mimeCharset);
        if (charset == null) {
            return fallback;
        }
        Charset override = charsetOverrides.get(charset);
        return override != null ? override : charset;
    }

    private static void monitor(DecodeMonitor monitor, String mimeCharset, String encoding, String encodedText, String dropDesc, String ... strings) throws IllegalArgumentException {
        if (monitor.isListening()) {
            String encodedWord = DecoderUtil.recombine(mimeCharset, encoding, encodedText);
            StringBuilder text = new StringBuilder();
            for (String str : strings) {
                text.append(str);
            }
            text.append(" (");
            text.append(encodedWord);
            text.append(")");
            String exceptionDesc = text.toString();
            if (monitor.warn(exceptionDesc, dropDesc)) {
                throw new IllegalArgumentException(text.toString());
            }
        }
    }

    private static String recombine(String mimeCharset, String encoding, String encodedText) {
        return "=?" + mimeCharset + "?" + encoding + "?" + encodedText + "?=";
    }

    private static String replaceUnderscores(String str) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

