/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.SecurableObjectBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.SecurableObjectPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class SecurableObjectSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, SecurableObjectBaseSQLProvider> SECURABLE_OBJECTS_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new SecurableObjectMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new SecurableObjectH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new SecurableObjectPostgreSQLProvider());

    public static SecurableObjectBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return SECURABLE_OBJECTS_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String batchInsertSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return SecurableObjectSQLProviderFactory.getProvider().batchInsertSecurableObjects(securableObjectPOs);
    }

    public static String batchSoftDeleteSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return SecurableObjectSQLProviderFactory.getProvider().batchSoftDeleteSecurableObjects(securableObjectPOs);
    }

    public static String softDeleteSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteSecurableObjectsByRoleId(roleId);
    }

    public static String softDeleteSecurableObjectsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteSecurableObjectsByMetalakeId(metalakeId);
    }

    public static String softDeleteObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteObjectRelsByMetadataObject(metadataObjectId, metadataObjectType);
    }

    public static String softDeleteObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteObjectRelsByCatalogId(catalogId);
    }

    public static String softDeleteObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteObjectRelsBySchemaId(schemaId);
    }

    public static String listSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return SecurableObjectSQLProviderFactory.getProvider().listSecurableObjectsByRoleId(roleId);
    }

    public static String deleteSecurableObjectsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return SecurableObjectSQLProviderFactory.getProvider().deleteSecurableObjectsByLegacyTimeline(legacyTimeline, limit);
    }

    static class SecurableObjectH2Provider
    extends SecurableObjectBaseSQLProvider {
        SecurableObjectH2Provider() {
        }
    }

    static class SecurableObjectMySQLProvider
    extends SecurableObjectBaseSQLProvider {
        SecurableObjectMySQLProvider() {
        }
    }
}

