/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.model.ModelDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericModel
implements Model,
SupportsTags,
SupportsPolicies {
    private final ModelDTO modelDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericModel(ModelDTO modelDTO, RESTClient restClient, Namespace modelNs) {
        this.modelDTO = modelDTO;
        ArrayList modelFullName = Lists.newArrayList((Object[])new String[]{modelNs.level(1), modelNs.level(2), modelDTO.name()});
        MetadataObject modelObject = MetadataObjects.of((List)modelFullName, (MetadataObject.Type)MetadataObject.Type.MODEL);
        this.objectTagOperations = new MetadataObjectTagOperations(modelNs.level(0), modelObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(modelNs.level(0), modelObject, restClient);
    }

    public Audit auditInfo() {
        return this.modelDTO.auditInfo();
    }

    public String name() {
        return this.modelDTO.name();
    }

    public String comment() {
        return this.modelDTO.comment();
    }

    public Map<String, String> properties() {
        return this.modelDTO.properties();
    }

    public int latestVersion() {
        return this.modelDTO.latestVersion();
    }

    public SupportsTags supportsTags() {
        return this;
    }

    public SupportsPolicies supportsPolicies() {
        return this;
    }

    public SupportsRoles supportsRoles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericModel)) {
            return false;
        }
        GenericModel that = (GenericModel)o;
        return this.modelDTO.equals((Object)that.modelDTO);
    }

    public int hashCode() {
        return this.modelDTO.hashCode();
    }

    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) throws TagAlreadyAssociatedException {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }
}

