/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.secret;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Attributes;
import org.apache.guacamole.net.auth.Connectable;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.TokenFilter;
import org.apache.guacamole.vault.ksm.GuacamoleExceptionSupplier;
import org.apache.guacamole.vault.ksm.conf.KsmConfigurationService;
import org.apache.guacamole.vault.ksm.secret.KsmClient;
import org.apache.guacamole.vault.ksm.secret.KsmClientFactory;
import org.apache.guacamole.vault.ksm.secret.KsmRecordService;
import org.apache.guacamole.vault.ksm.user.KsmDirectory;
import org.apache.guacamole.vault.secret.VaultSecretService;
import org.apache.guacamole.vault.secret.WindowsUsername;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KsmSecretService
implements VaultSecretService {
    private static final Logger logger = LoggerFactory.getLogger(VaultSecretService.class);
    @Inject
    private KsmRecordService recordService;
    @Inject
    private KsmConfigurationService confService;
    @Inject
    private KsmClientFactory ksmClientFactory;
    private final ConcurrentMap<String, KsmClient> ksmClientMap = new ConcurrentHashMap<String, KsmClient>();

    private KsmClient getClient(@Nonnull String ksmConfig) throws GuacamoleException {
        KsmClient ksmClient = (KsmClient)this.ksmClientMap.get(ksmConfig);
        if (ksmClient != null) {
            return ksmClient;
        }
        SecretsManagerOptions options = this.confService.getSecretsManagerOptions(ksmConfig);
        ksmClient = this.ksmClientFactory.create(options, this.confService.getKsmApiInterval());
        KsmClient prevClient = this.ksmClientMap.putIfAbsent(ksmConfig, ksmClient);
        return prevClient != null ? prevClient : ksmClient;
    }

    public String canonicalize(String nameComponent) {
        try {
            return URLEncoder.encode(nameComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }

    public Future<String> getValue(final UserContext userContext, final Connectable connectable, final String name) throws GuacamoleException {
        final String ksmConfig = this.getConnectionGroupKsmConfig(userContext, connectable);
        return this.getClient(ksmConfig).getSecret(name, new GuacamoleExceptionSupplier<Future<String>>(){

            @Override
            public Future<String> get() throws GuacamoleException {
                String userKsmConfig = KsmSecretService.this.getUserKSMConfig(userContext, connectable);
                if (userKsmConfig != null && !Objects.equal((Object)userKsmConfig, (Object)ksmConfig)) {
                    return KsmSecretService.this.getClient(userKsmConfig).getSecret(name);
                }
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    public Future<String> getValue(String name) throws GuacamoleException {
        return this.getClient(this.confService.getKsmConfig()).getSecret(name);
    }

    private void addRecordTokens(Map<String, Future<String>> tokens, String prefix, KeeperRecord record) throws GuacamoleException {
        String passphrase;
        String password;
        String username;
        if (record == null) {
            return;
        }
        String domain = this.recordService.getDomain(record);
        if (domain != null) {
            tokens.put(prefix + "DOMAIN", CompletableFuture.completedFuture(domain));
        }
        if ((username = this.recordService.getUsername(record)) != null) {
            if (domain == null && this.confService.getSplitWindowsUsernames()) {
                WindowsUsername usernameAndDomain = WindowsUsername.splitWindowsUsernameFromDomain((String)username);
                tokens.put(prefix + "USERNAME", CompletableFuture.completedFuture(usernameAndDomain.getUsername()));
                if (usernameAndDomain.hasDomain()) {
                    tokens.put(prefix + "DOMAIN", CompletableFuture.completedFuture(usernameAndDomain.getDomain()));
                }
            } else {
                tokens.put(prefix + "USERNAME", CompletableFuture.completedFuture(username));
            }
        }
        if ((password = this.recordService.getPassword(record)) != null) {
            tokens.put(prefix + "PASSWORD", CompletableFuture.completedFuture(password));
        }
        if ((passphrase = this.recordService.getPassphrase(record)) != null) {
            tokens.put(prefix + "PASSPHRASE", CompletableFuture.completedFuture(passphrase));
        }
        Future<String> privateKey = this.recordService.getPrivateKey(record);
        tokens.put(prefix + "KEY", privateKey);
    }

    @Nonnull
    private String getConnectionGroupKsmConfig(UserContext userContext, Connectable connectable) throws GuacamoleException {
        ConnectionGroup group;
        if (!(connectable instanceof Connection) && !(connectable instanceof ConnectionGroup)) {
            logger.warn("Unsupported Connectable type: {}; skipping KSM config lookup.", (Object)connectable.getClass());
            return this.confService.getKsmConfig();
        }
        String parentIdentifier = connectable instanceof Connection ? ((Connection)connectable).getParentIdentifier() : ((ConnectionGroup)connectable).getIdentifier();
        HashSet<String> observedIdentifiers = new HashSet<String>();
        observedIdentifiers.add(parentIdentifier);
        Directory connectionGroupDirectory = ((KsmDirectory)userContext.getConnectionGroupDirectory()).getUnderlyingDirectory();
        while ((group = (ConnectionGroup)connectionGroupDirectory.get(parentIdentifier)) != null) {
            String ksmConfig = (String)group.getAttributes().get("ksm-config");
            if (ksmConfig != null && !ksmConfig.trim().isEmpty()) {
                return ksmConfig;
            }
            parentIdentifier = group.getParentIdentifier();
            if (observedIdentifiers.add(parentIdentifier)) continue;
            break;
        }
        return this.confService.getKsmConfig();
    }

    private boolean isKsmUserConfigEnabled(Connectable connectable) {
        if (connectable instanceof Attributes) {
            return "true".equals(((Attributes)connectable).getAttributes().get("ksm-user-config-enabled"));
        }
        return false;
    }

    private String getUserKSMConfig(UserContext userContext, Connectable connectable) throws GuacamoleException {
        if (this.confService.getAllowUserConfig() && this.isKsmUserConfigEnabled(connectable)) {
            User self = (User)((KsmDirectory)userContext.getUserDirectory()).getUnderlyingDirectory().get(userContext.self().getIdentifier());
            return (String)self.getAttributes().get("ksm-config");
        }
        return null;
    }

    private void addConnectableTokens(GuacamoleConfiguration config, KsmClient ksm, Map<String, Future<String>> tokens, Map<String, String> parameters, TokenFilter filter) throws GuacamoleException {
        String hostname = parameters.get("hostname");
        if (hostname != null && !hostname.isEmpty()) {
            this.addRecordTokens(tokens, "KEEPER_SERVER_", ksm.getRecordByHost(filter.filter(hostname)));
        }
        if ("rdp".equals(config.getProtocol())) {
            String gatewayUsername;
            String username;
            String gatewayHostname = parameters.get("gateway-hostname");
            if (gatewayHostname != null && !gatewayHostname.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_GATEWAY_", ksm.getRecordByHost(filter.filter(gatewayHostname)));
            }
            String domain = parameters.get("domain");
            String filteredDomain = null;
            if (domain != null && !domain.isEmpty()) {
                filteredDomain = filter.filter(domain);
                this.addRecordTokens(tokens, "KEEPER_DOMAIN_", ksm.getRecordByDomain(filteredDomain));
            }
            String gatewayDomain = parameters.get("gateway-domain");
            String filteredGatewayDomain = null;
            if (gatewayDomain != null && !gatewayDomain.isEmpty()) {
                filteredGatewayDomain = filter.filter(gatewayDomain);
                this.addRecordTokens(tokens, "KEEPER_GATEWAY_DOMAIN_", ksm.getRecordByDomain(filteredGatewayDomain));
            }
            if (!this.confService.getMatchUserRecordsByDomain()) {
                filteredDomain = null;
                filteredGatewayDomain = null;
            }
            if ((username = parameters.get("username")) != null && !username.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_USER_", ksm.getRecordByLogin(filter.filter(username), filteredDomain));
            }
            if ((gatewayUsername = parameters.get("gateway-username")) != null && !gatewayUsername.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_GATEWAY_USER_", ksm.getRecordByLogin(filter.filter(gatewayUsername), filteredGatewayDomain));
            }
        } else {
            String username = parameters.get("username");
            if (username != null && !username.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_USER_", ksm.getRecordByLogin(filter.filter(username), null));
            }
        }
    }

    public Map<String, Future<String>> getTokens(UserContext userContext, Connectable connectable, GuacamoleConfiguration config, TokenFilter filter) throws GuacamoleException {
        HashMap<String, Future<String>> tokens = new HashMap<String, Future<String>>();
        Map parameters = config.getParameters();
        String userKsmConfig = this.getUserKSMConfig(userContext, connectable);
        if (userKsmConfig != null && !userKsmConfig.trim().isEmpty()) {
            this.addConnectableTokens(config, this.getClient(userKsmConfig), tokens, parameters, filter);
        }
        String ksmConfig = this.getConnectionGroupKsmConfig(userContext, connectable);
        this.addConnectableTokens(config, this.getClient(ksmConfig), tokens, parameters, filter);
        return tokens;
    }
}

