/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HBCKMetaTableAccessor {
    static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    private static final Logger LOG = LoggerFactory.getLogger(HBCKMetaTableAccessor.class);
    private static final byte[] MERGE_QUALIFIER_PREFIX = Bytes.toBytes((String)"merge");

    private HBCKMetaTableAccessor() {
    }

    public static List<RegionInfo> getMergeRegions(Cell[] cells) {
        if (cells == null) {
            return null;
        }
        ArrayList<RegionInfo> regionsToMerge = null;
        for (Cell cell : cells) {
            RegionInfo ri;
            if (!HBCKMetaTableAccessor.isMergeQualifierPrefix(cell) || (ri = RegionInfo.parseFromOrNull((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())) == null) continue;
            if (regionsToMerge == null) {
                regionsToMerge = new ArrayList<RegionInfo>();
            }
            regionsToMerge.add(ri);
        }
        return regionsToMerge;
    }

    public static void deleteRegionInfo(Connection connection, RegionInfo regionInfo) throws IOException {
        Delete delete = new Delete(regionInfo.getRegionName());
        delete.addFamily(HConstants.CATALOG_FAMILY, Long.MAX_VALUE);
        HBCKMetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted {}", (Object)regionInfo.getRegionNameAsString());
    }

    private static boolean isMergeQualifierPrefix(Cell cell) {
        return CellUtil.matchingFamily((Cell)cell, (byte[])HConstants.CATALOG_FAMILY) && HBCKMetaTableAccessor.qualifierStartsWith(cell, MERGE_QUALIFIER_PREFIX);
    }

    private static boolean qualifierStartsWith(Cell left, byte[] startsWith) {
        if (startsWith == null || startsWith.length == 0) {
            throw new IllegalArgumentException("Cannot pass an empty startsWith");
        }
        return Bytes.equals((byte[])left.getQualifierArray(), (int)left.getQualifierOffset(), (int)startsWith.length, (byte[])startsWith, (int)0, (int)startsWith.length);
    }

    private static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        if (connection == null) {
            throw new NullPointerException("No connection");
        }
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        try (Table t = connection.getTable(TableName.META_TABLE_NAME);){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            deletes.add(d);
            LOG.debug("Add {} delete to meta table", (Object)deletes);
            t.delete(deletes);
        }
    }

    public static List<RegionInfo> getTableRegions(Connection conn, TableName table) throws IOException {
        MetaScanner<RegionInfo> scanner = new MetaScanner<RegionInfo>();
        String startRow = Bytes.toString((byte[])table.getName()) + ",,";
        String stopRow = Bytes.toString((byte[])table.getName()) + " ,,";
        return scanner.scanMeta(conn, scan -> {
            scan.withStartRow(Bytes.toBytes((String)startRow));
            scan.withStopRow(Bytes.toBytes((String)stopRow));
        }, r -> {
            Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            if (cell != null) {
                RegionInfo info = RegionInfo.parseFromOrNull((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                return info;
            }
            return null;
        });
    }

    public static List<TableName> getTables(Connection conn) throws IOException {
        MetaScanner<TableName> scanner = new MetaScanner<TableName>();
        return scanner.scanMeta(conn, scan -> scan.addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER), r -> {
            byte[] rowBytes = r.getRow();
            String table = Bytes.toString((byte[])rowBytes);
            if (table.lastIndexOf(44) > 0) {
                table = table.substring(0, table.lastIndexOf(44));
            }
            return TableName.valueOf((String)table);
        });
    }

    public static void addRegionToMeta(Connection conn, RegionInfo region) throws IOException {
        Put put = HBCKMetaTableAccessor.makePutFromRegionInfo(region, System.currentTimeMillis());
        HBCKMetaTableAccessor.addRegionStateToPut(put, RegionState.State.CLOSED);
        conn.getTable(TableName.META_TABLE_NAME).put(put);
    }

    public static List<RegionInfo> getAllRegions(Connection conn) throws IOException {
        MetaScanner<RegionInfo> scanner = new MetaScanner<RegionInfo>();
        return scanner.scanMeta(conn, scan -> scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER), r -> {
            Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            RegionInfo info = RegionInfo.parseFromOrNull((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            return info.isSplit() ? null : info;
        });
    }

    public static Map<TableName, TableState> getAllTablesStates(Connection conn) throws IOException {
        MetaScanner<Pair> scanner = new MetaScanner<Pair>();
        HashMap<TableName, TableState> resultMap = new HashMap<TableName, TableState>();
        scanner.scanMeta(conn, scan -> scan.addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER), r -> {
            try {
                TableState state = HBCKMetaTableAccessor.getTableState(r);
                TableName name = TableName.valueOf((byte[])r.getRow());
                resultMap.put(name, state);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
            return null;
        });
        return resultMap;
    }

    public static byte[] getTableStartRowForMeta(TableName tableName) {
        if (tableName == null) {
            return null;
        }
        byte[] startRow = new byte[tableName.getName().length + 2];
        System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
        startRow[startRow.length - 2] = 44;
        startRow[startRow.length - 1] = 44;
        return startRow;
    }

    public static byte[] getTableStopRowForMeta(TableName tableName) {
        if (tableName == null) {
            return null;
        }
        byte[] stopRow = new byte[tableName.getName().length + 3];
        System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
        stopRow[stopRow.length - 3] = 32;
        stopRow[stopRow.length - 2] = 44;
        stopRow[stopRow.length - 1] = 44;
        return stopRow;
    }

    public static byte[] getMetaKeyForRegion(RegionInfo regionInfo) {
        if (regionInfo.isMetaRegion()) {
            return RegionInfoBuilder.newBuilder((TableName)regionInfo.getTable()).setRegionId(regionInfo.getRegionId()).setReplicaId(0).setOffline(regionInfo.isOffline()).build().getRegionName();
        }
        return RegionInfoBuilder.newBuilder((TableName)regionInfo.getTable()).setStartKey(regionInfo.getStartKey()).setEndKey(regionInfo.getEndKey()).setSplit(regionInfo.isSplit()).setRegionId(regionInfo.getRegionId()).setReplicaId(0).setOffline(regionInfo.isOffline()).build().getRegionName();
    }

    public static Put addLocation(Put p, ServerName sn, long openSeqNum, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        return p.add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HBCKMetaTableAccessor.getServerColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)sn.getAddress().toString())).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HBCKMetaTableAccessor.getStartCodeColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((long)sn.getStartcode())).build()).add(builder.clear().setRow(p.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HBCKMetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((long)openSeqNum)).build());
    }

    public static int getRegionCount(Connection connection, TableName tableName) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(tableName);){
            List locations = locator.getAllRegionLocations();
            int n = locations == null ? 0 : locations.size();
            return n;
        }
    }

    public static TableState getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER);
        if (cell == null) {
            return null;
        }
        try {
            return TableState.parseFrom((TableName)TableName.valueOf((byte[])r.getRow()), (byte[])Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength()));
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static TableState getTableState(Connection conn, TableName tableName) throws IOException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return new TableState(tableName, TableState.State.ENABLED);
        }
        Table metaHTable = conn.getTable(TableName.META_TABLE_NAME);
        Get get = new Get(tableName.getName()).addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER);
        Result result = metaHTable.get(get);
        return HBCKMetaTableAccessor.getTableState(result);
    }

    public static Put makePutFromTableState(TableState state, long ts) {
        Put put = new Put(state.getTableName().getName(), ts);
        put.addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER, state.convert().toByteArray());
        return put;
    }

    public static Put makePutFromRegionInfo(RegionInfo region, long ts) throws IOException {
        Put put = new Put(region.getRegionName(), ts);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.REGIONINFO_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray((RegionInfo)RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region))).build());
        return put;
    }

    private static void addRegionStateToPut(Put put, RegionState.State state) throws IOException {
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.STATE_QUALIFIER).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)state.name())).build());
    }

    public static void deleteTableState(Connection connection, TableName table) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(table.getName());
        delete.addColumns(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER, time);
        HBCKMetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info("Deleted table " + table + " state from META");
    }

    public static void updateTableState(Connection conn, TableName tableName, TableState.State actual) throws IOException {
        Put put = HBCKMetaTableAccessor.makePutFromTableState(new TableState(tableName, actual), EnvironmentEdgeManager.currentTime());
        conn.getTable(TableName.META_TABLE_NAME).put(put);
    }

    public static RegionInfo getRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, qualifier);
        if (cell == null) {
            return null;
        }
        return RegionInfo.parseFromOrNull((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    private static HRegionLocation getRegionLocation(Result r, RegionInfo regionInfo, int replicaId) {
        ServerName serverName = HBCKMetaTableAccessor.getServerName(r, replicaId);
        long seqNum = HBCKMetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        RegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regionInfo, (int)replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HBCKMetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    @InterfaceAudience.Private
    public static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = HBCKMetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        byte[] startcodeColumn = HBCKMetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf((String)hostAndPort, (long)Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell, e);
            return null;
        }
    }

    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        RegionInfo regionInfo = HBCKMetaTableAccessor.getRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap familyMap = r.getNoVersionMap();
        locations.add(HBCKMetaTableAccessor.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(HConstants.CATALOG_FAMILY);
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = HBCKMetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = HBCKMetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = HBCKMetaTableAccessor.getRegionLocation(r, regionInfo, replicaId);
            if (location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    public static PairOfSameType<RegionInfo> getDaughterRegions(Result data) {
        RegionInfo splitA = HBCKMetaTableAccessor.getRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        RegionInfo splitB = HBCKMetaTableAccessor.getRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType((Object)splitA, (Object)splitB);
    }

    @VisibleForTesting
    static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes((String)("sn_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes((String)("server_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes((String)("serverstartcode_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes((String)("seqnumDuringOpen_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString((byte[])serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    public static class MetaScanner<R> {
        public List<R> scanMeta(Connection conn, Consumer<Scan> scanDecorator, Function<Result, R> scanProcessor) throws IOException {
            Result result;
            Scan metaScan = new Scan();
            scanDecorator.accept(metaScan);
            Table metaTable = conn.getTable(TableName.META_TABLE_NAME);
            ResultScanner rs = metaTable.getScanner(metaScan);
            ArrayList<R> results = new ArrayList<R>();
            while ((result = rs.next()) != null) {
                R processedResult = scanProcessor.apply(result);
                if (processedResult == null) continue;
                results.add(processedResult);
            }
            return results;
        }
    }
}

