/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category({ LargeTests.class, ClientTests.class })
public class TestAsyncResultScannerCursor extends AbstractTestResultScannerCursor {

  @ClassRule
  public static final HBaseClassTestRule CLASS_RULE =
    HBaseClassTestRule.forClass(TestAsyncResultScannerCursor.class);

  private static AsyncConnection CONN;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    AbstractTestScanCursor.setUpBeforeClass();
    CONN = ConnectionFactory.createAsyncConnection(TEST_UTIL.getConfiguration()).get();
  }

  public static void tearDownAfterClass() throws Exception {
    if (CONN != null) {
      CONN.close();
    }
    AbstractTestScanCursor.tearDownAfterClass();
  }

  @Override
  protected ResultScanner getScanner(Scan scan) throws Exception {
    return CONN.getTable(TABLE_NAME, ForkJoinPool.commonPool()).getScanner(scan);
  }
}
