/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class YAISCalculator {
    public static void main(String[] args) {
        YAISCalculator.doAssignment(new int[]{5}, 120, 3);
    }

    private static void doAssignment(int[] nodes, int partitions, int replication) {
        int N = nodes[0];
        int totalNodes = 0;
        for (int temp : nodes) {
            totalNodes += temp;
        }
        Assignment assignment = new Assignment(totalNodes, partitions, replication);
        int nodeId = 0;
        for (int i = 0; i < partitions; ++i) {
            assignment.assign(i, 0, nodeId);
            nodeId = (nodeId + 1) % N;
        }
        Random random = new Random();
        for (int r = 1; r < replication; ++r) {
            for (int id = 0; id < N; ++id) {
                Integer[] partitionsPerNode = assignment.getPartitionsPerNode(id, 0);
                boolean[] used = new boolean[partitionsPerNode.length];
                Arrays.fill(used, false);
                System.out.println(id + "-" + partitionsPerNode.length);
                nodeId = (id + r) % N;
                int count = partitionsPerNode.length;
                boolean done = false;
                do {
                    if (nodeId != id) {
                        int nextInt = random.nextInt(count);
                        int temp = 0;
                        for (int b = 0; b < used.length; ++b) {
                            if (used[b] || temp != nextInt) continue;
                            assignment.assign(partitionsPerNode[b], r, nodeId);
                            used[b] = true;
                            break;
                        }
                    }
                    nodeId = (nodeId + 1) % N;
                } while (count > 0);
            }
        }
        if (nodes.length > 1) {
            int prevNodeCount = nodes[0];
            for (int i = 1; i < nodes.length; ++i) {
                int newNodeCount = prevNodeCount + nodes[i];
                int masterPartitionsToMove = (int)(((double)partitions * 1.0 / (double)prevNodeCount - (double)partitions * 1.0 / (double)newNodeCount) * 1.0 * (double)prevNodeCount);
                while (masterPartitionsToMove > 0) {
                }
            }
        }
        assignment.printPerNode();
    }

    static class Node {
        private final int replication;
        ArrayList<LinkedList<Integer>> partitionLists;

        public Node(int replication) {
            this.replication = replication;
            this.partitionLists = new ArrayList(replication);
            for (int i = 0; i < replication; ++i) {
                this.partitionLists.add(new LinkedList());
            }
        }
    }

    static class Partition {
        final int partionId;
        int[] nodeIds;

        public Partition(int partionId, int replication) {
            this.partionId = partionId;
            this.nodeIds = new int[replication];
            Arrays.fill(this.nodeIds, -1);
        }
    }

    static class Assignment {
        private final int numNodes;
        private final int replication;
        Partition[] partitions;
        Node[] nodes;

        public Assignment(int numNodes, int numPartitions, int replication) {
            int i;
            this.numNodes = numNodes;
            this.replication = replication;
            this.partitions = new Partition[numPartitions];
            for (i = 0; i < numPartitions; ++i) {
                this.partitions[i] = new Partition(i, replication);
            }
            this.nodes = new Node[numNodes];
            for (i = 0; i < numNodes; ++i) {
                this.nodes[i] = new Node(replication);
            }
        }

        public void assign(int partitionId, int replicaId, int nodeId) {
            System.out.println("Assigning (" + partitionId + "," + replicaId + ") to " + nodeId);
            this.partitions[partitionId].nodeIds[replicaId] = nodeId;
            this.nodes[nodeId].partitionLists.get(replicaId).push(partitionId);
        }

        public void unassign(int partitionId, int replicaId) {
        }

        Integer[] getPartitionsPerNode(int nodeId, int replicaId) {
            ArrayList<Integer> partitionsList = new ArrayList<Integer>();
            for (Partition p : this.partitions) {
                if (p.nodeIds[replicaId] != nodeId) continue;
                partitionsList.add(p.partionId);
            }
            Integer[] array = new Integer[partitionsList.size()];
            partitionsList.toArray(array);
            return array;
        }

        public void printPerNode() {
            for (int nodeId = 0; nodeId < this.numNodes; ++nodeId) {
                for (int r = 0; r < this.replication; ++r) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("(").append(nodeId).append(",").append(r).append("):\t");
                    Node node = this.nodes[nodeId];
                    LinkedList<Integer> linkedList = node.partitionLists.get(r);
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        int partitionId = (Integer)iterator.next();
                        sb.append(partitionId).append(",");
                    }
                    System.out.println(sb.toString());
                }
            }
        }
    }
}

