/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class ConfigStringUtil {
    private static final String CONCATENATE_CONFIG_SPLITTER = ",";
    private static final String CONCATENATE_CONFIG_JOINER = "=";

    private ConfigStringUtil() {
        throw new UnsupportedOperationException("Utility class ConfigStringUtil and cannot be instantiated");
    }

    public static Map<String, String> parseConcatenatedConfig(String inputStr) {
        String[] pathPairs;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (inputStr == null || inputStr.isEmpty()) {
            return resultMap;
        }
        for (String pair : pathPairs = inputStr.trim().split(CONCATENATE_CONFIG_SPLITTER)) {
            String[] values = pair.split(CONCATENATE_CONFIG_JOINER);
            if (values.length != 2 || values[0].isEmpty() || values[1].isEmpty()) {
                throw new IllegalArgumentException(String.format("Domain-Value pair %s is not valid.", pair));
            }
            resultMap.put(values[0].trim(), values[1].trim());
        }
        return resultMap;
    }

    public static String concatenateMapping(Map<String, String> inputMap) {
        return inputMap.entrySet().stream().map(entry -> (String)entry.getKey() + CONCATENATE_CONFIG_JOINER + (String)entry.getValue()).collect(Collectors.joining(CONCATENATE_CONFIG_SPLITTER));
    }
}

