/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class BeanParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    private ServiceLocator locator;

    @Inject
    public BeanParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.BEAN_PARAM);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        return new BeanParamValueFactory(this.locator, parameter);
    }

    private static final class BeanParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final Parameter parameter;
        private final ServiceLocator locator;

        private BeanParamValueFactory(ServiceLocator locator, Parameter parameter) {
            this.locator = locator;
            this.parameter = parameter;
        }

        public Object provide() {
            Class<?> rawType = this.parameter.getRawType();
            Object fromHk2 = this.locator.getService(rawType, new Annotation[0]);
            if (fromHk2 != null) {
                return fromHk2;
            }
            AbstractActiveDescriptor descriptor = BuilderHelper.activeLink(rawType).in(RequestScoped.class).build();
            ActiveDescriptor reifiedDescriptor = this.locator.reifyDescriptor((Descriptor)descriptor);
            return reifiedDescriptor.create(this.locator.getServiceHandle(reifiedDescriptor));
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<BeanParam> {
        public InjectionResolver() {
            super(BeanParamValueFactoryProvider.class);
        }
    }
}

