/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.metadatastore.accessor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.msdcommon.callback.RoutingDataListener;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.rest.metadatastore.ZkMetadataStoreDirectory;
import org.apache.helix.rest.metadatastore.accessor.MetadataStoreRoutingDataReader;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.Watcher;

public class ZkRoutingDataReader
implements MetadataStoreRoutingDataReader,
IZkDataListener,
IZkChildListener,
IZkStateListener {
    private final String _namespace;
    private final String _zkAddress;
    private final HelixZkClient _zkClient;
    private final RoutingDataListener _routingDataListener;

    public ZkRoutingDataReader(String namespace, String zkAddress, RoutingDataListener routingDataListener) {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("namespace cannot be null or empty!");
        }
        this._namespace = namespace;
        if (zkAddress == null || zkAddress.isEmpty()) {
            throw new IllegalArgumentException("Zk address cannot be null or empty!");
        }
        this._zkAddress = zkAddress;
        this._zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
        ZkMetadataStoreDirectory.createRoutingDataPath(this._zkClient, this._zkAddress);
        this._routingDataListener = routingDataListener;
        if (this._routingDataListener != null) {
            this._zkClient.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        }
    }

    @Override
    public Map<String, List<String>> getRoutingData() throws InvalidRoutingDataException {
        List allRealmAddresses;
        HashMap<String, List<String>> routingData = new HashMap<String, List<String>>();
        try {
            allRealmAddresses = this._zkClient.getChildren("/METADATA_STORE_ROUTING_DATA");
        }
        catch (ZkNoNodeException e) {
            throw new InvalidRoutingDataException("Routing data directory ZNode /METADATA_STORE_ROUTING_DATA does not exist. Routing ZooKeeper address: " + this._zkAddress);
        }
        if (allRealmAddresses != null) {
            for (String realmAddress : allRealmAddresses) {
                ZNRecord record = (ZNRecord)this._zkClient.readData("/METADATA_STORE_ROUTING_DATA/" + realmAddress, true);
                if (record == null) continue;
                List shardingKeys = record.getListField("ZK_PATH_SHARDING_KEYS");
                routingData.put(realmAddress, shardingKeys != null ? shardingKeys : Collections.emptyList());
            }
        }
        return routingData;
    }

    @Override
    public synchronized void close() {
        this._zkClient.unsubscribeAll();
        this._zkClient.close();
    }

    public synchronized void handleDataChange(String s, Object o) {
        if (this._zkClient == null || this._zkClient.isClosed()) {
            return;
        }
        this._routingDataListener.refreshRoutingData(this._namespace);
    }

    public synchronized void handleDataDeleted(String s) {
        this.handleResubscription();
    }

    public synchronized void handleChildChange(String s, List<String> list) {
        this.handleResubscription();
    }

    public synchronized void handleStateChanged(Watcher.Event.KeeperState state) {
        if (this._zkClient == null || this._zkClient.isClosed()) {
            return;
        }
        this._routingDataListener.refreshRoutingData(this._namespace);
    }

    public synchronized void handleNewSession(String sessionId) {
        if (this._zkClient == null || this._zkClient.isClosed()) {
            return;
        }
        this._routingDataListener.refreshRoutingData(this._namespace);
    }

    public synchronized void handleSessionEstablishmentError(Throwable error) {
        if (this._zkClient == null || this._zkClient.isClosed()) {
            return;
        }
        this._routingDataListener.refreshRoutingData(this._namespace);
    }

    private void handleResubscription() {
        if (this._zkClient == null || this._zkClient.isClosed()) {
            return;
        }
        this._zkClient.unsubscribeAll();
        this._zkClient.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this._routingDataListener.refreshRoutingData(this._namespace);
    }
}

