/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.msdcommon.util.ZkValidationUtil;
import org.apache.helix.rest.server.filters.ClusterAuth;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterAuth
@Path(value="/clusters/{clusterId}/propertyStore")
public class PropertyStoreAccessor
extends AbstractHelixResource {
    private static Logger LOG = LoggerFactory.getLogger(PropertyStoreAccessor.class);
    private static final String CONTENT_KEY = "content";
    private static final ZNRecordSerializer ZN_RECORD_SERIALIZER = new ZNRecordSerializer();

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{path: .+}")
    public Response getPropertyByPath(@PathParam(value="clusterId") String clusterId, @PathParam(value="path") String path) {
        if (!ZkValidationUtil.isPathValid((String)(path = "/" + (String)path))) {
            LOG.info("The propertyStore path {} is invalid for cluster {}", path, (Object)clusterId);
            return this.badRequest("Invalid path string. Valid path strings use slash as the directory separator and names the location of ZNode");
        }
        String recordPath = PropertyPathBuilder.propertyStore((String)clusterId) + (String)path;
        BaseDataAccessor<byte[]> propertyStoreDataAccessor = this.getByteArrayDataAccessor();
        if (!propertyStoreDataAccessor.exists(recordPath, AccessOption.PERSISTENT)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)String.format("The property store path %s doesn't exist", recordPath)).build());
        }
        byte[] bytes = (byte[])propertyStoreDataAccessor.get(recordPath, null, AccessOption.PERSISTENT);
        if (bytes == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NO_CONTENT).build());
        }
        ZNRecord znRecord = (ZNRecord)ZN_RECORD_SERIALIZER.deserialize(bytes);
        if (znRecord == null) {
            ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
            jsonNode.put(CONTENT_KEY, new String(bytes));
            return this.JSONRepresentation(jsonNode);
        }
        return this.JSONRepresentation(znRecord);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{path: .+}")
    public Response putPropertyByPath(@PathParam(value="clusterId") String clusterId, @PathParam(value="path") String path, @QueryParam(value="isZNRecord") @DefaultValue(value="true") String isZNRecord, String content) {
        if (!ZkValidationUtil.isPathValid((String)(path = "/" + (String)path))) {
            LOG.info("The propertyStore path {} is invalid for cluster {}", path, (Object)clusterId);
            return this.badRequest("Invalid path string. Valid path strings use slash as the directory separator and names the location of ZNode");
        }
        String recordPath = PropertyPathBuilder.propertyStore((String)clusterId) + (String)path;
        try {
            block8: {
                if (Boolean.parseBoolean(isZNRecord)) {
                    try {
                        ZNRecord record = PropertyStoreAccessor.toZNRecord(content);
                        BaseDataAccessor propertyStoreDataAccessor = this.getDataAccssor(clusterId).getBaseDataAccessor();
                        if (!propertyStoreDataAccessor.set(recordPath, (Object)record, AccessOption.PERSISTENT)) {
                            return this.serverError("Failed to set content: " + content + " in PropertyStore path: " + (String)path);
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        LOG.error("Failed to deserialize content " + content + " into a ZNRecord!", (Throwable)e);
                        return this.badRequest("Failed to write to path: " + recordPath + "! Content is not a valid ZNRecord!");
                    }
                }
                BaseDataAccessor<byte[]> propertyStoreDataAccessor = this.getByteArrayDataAccessor();
                if (!propertyStoreDataAccessor.set(recordPath, (Object)content.getBytes(), AccessOption.PERSISTENT)) {
                    return this.serverError("Failed to set content: " + content + " in PropertyStore path: " + (String)path);
                }
            }
            return this.OK();
        }
        catch (Exception e) {
            return this.serverError(e);
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{path: .+}")
    public Response deletePropertyByPath(@PathParam(value="clusterId") String clusterId, @PathParam(value="path") String path) {
        if (!ZkValidationUtil.isPathValid((String)(path = "/" + (String)path))) {
            LOG.info("The propertyStore path {} is invalid for cluster {}", path, (Object)clusterId);
            return this.badRequest("Invalid path string. Valid path strings use slash as the directory separator and names the location of ZNode");
        }
        String recordPath = PropertyPathBuilder.propertyStore((String)clusterId) + (String)path;
        BaseDataAccessor<byte[]> propertyStoreDataAccessor = this.getByteArrayDataAccessor();
        if (!propertyStoreDataAccessor.remove(recordPath, AccessOption.PERSISTENT)) {
            return this.serverError("Failed to delete PropertyStore record in path: " + (String)path);
        }
        return this.OK();
    }
}

