/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.msdcommon.mock;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMetadataStoreDirectoryServer {
    private static final Logger LOG = LoggerFactory.getLogger(MockMetadataStoreDirectoryServer.class);
    protected static final String REST_PREFIX = "/admin/v2/namespaces/";
    protected static final String ZK_REALM_ENDPOINT = "/metadata-store-realms";
    protected static final int NOT_IMPLEMENTED = 501;
    protected static final int OK = 200;
    protected static final int STOP_WAIT_SEC = 10;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final String _hostname;
    protected final int _mockServerPort;
    protected final Map<String, Collection<String>> _routingDataMap;
    protected final String _namespace;
    protected HttpServer _server;
    protected final ThreadPoolExecutor _executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);

    public MockMetadataStoreDirectoryServer(String hostname, int port, String namespace, Map<String, Collection<String>> routingData) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("hostname cannot be null or empty!");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port is not a valid port!");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("namespace cannot be null or empty!");
        }
        if (routingData == null || routingData.isEmpty()) {
            throw new IllegalArgumentException("routingData cannot be null or empty!");
        }
        this._hostname = hostname;
        this._mockServerPort = port;
        this._namespace = namespace;
        this._routingDataMap = routingData;
    }

    public void startServer() throws IOException {
        this._server = HttpServer.create(new InetSocketAddress(this._hostname, this._mockServerPort), 0);
        this.generateContexts();
        this._server.setExecutor(this._executor);
        this._server.start();
        LOG.info("Started MockMetadataStoreDirectoryServer at " + this._hostname + ":" + this._mockServerPort + "!");
    }

    public void stopServer() {
        if (this._server != null) {
            this._server.stop(10);
        }
        this._executor.shutdown();
        LOG.info("Stopped MockMetadataStoreDirectoryServer at " + this._hostname + ":" + this._mockServerPort + "!");
    }

    public String getEndpoint() {
        return "http://" + this._hostname + ":" + this._mockServerPort + REST_PREFIX + this._namespace;
    }

    private void generateContexts() {
        List result = this._routingDataMap.entrySet().stream().map(entry -> ImmutableMap.of((Object)"realm", entry.getKey(), (Object)"shardingKeys", entry.getValue())).collect(Collectors.toList());
        this._server.createContext(REST_PREFIX + this._namespace + "/routing-data", this.createHttpHandler((Map<String, Object>)ImmutableMap.of((Object)"namespace", (Object)this._namespace, (Object)"routingData", result)));
        this._server.createContext(REST_PREFIX + this._namespace + ZK_REALM_ENDPOINT, this.createHttpHandler((Map<String, Object>)ImmutableMap.of((Object)"realms", this._routingDataMap.keySet())));
        this._routingDataMap.forEach((zkRealm, shardingKeyList) -> this._server.createContext(REST_PREFIX + this._namespace + "/metadata-store-realms/" + zkRealm, this.createHttpHandler((Map<String, Object>)ImmutableMap.of((Object)"realm", (Object)zkRealm, (Object)"shardingKeys", (Object)shardingKeyList))));
    }

    private HttpHandler createHttpHandler(Map<String, Object> keyValuePairs) {
        return httpExchange -> {
            Object htmlResponse;
            OutputStream outputStream = httpExchange.getResponseBody();
            if (SupportedHttpVerbs.GET.name().equals(httpExchange.getRequestMethod())) {
                htmlResponse = OBJECT_MAPPER.writeValueAsString((Object)keyValuePairs);
                httpExchange.sendResponseHeaders(200, ((String)htmlResponse).length());
            } else {
                htmlResponse = httpExchange.getRequestMethod() + " is not supported!\n";
                httpExchange.sendResponseHeaders(501, ((String)htmlResponse).length());
            }
            outputStream.write(((String)htmlResponse).getBytes());
            outputStream.flush();
            outputStream.close();
        };
    }

    protected static enum SupportedHttpVerbs {
        GET;

    }
}

