/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.WorkflowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(ResourceComputationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache");
        }
        LinkedHashMap<String, Resource> resourceMap = new LinkedHashMap<String, Resource>();
        LinkedHashMap<String, Resource> resourceToRebalance = new LinkedHashMap<String, Resource>();
        Map<String, IdealState> idealStates = cache.getIdealStates();
        boolean isTaskCache = cache instanceof WorkflowControllerDataProvider;
        this.processIdealStates(cache, resourceMap, resourceToRebalance, idealStates, isTaskCache);
        if (isTaskCache) {
            WorkflowControllerDataProvider taskDataCache = (WorkflowControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
            this.processWorkflowConfigs(taskDataCache, resourceMap, resourceToRebalance);
            this.processJobConfigs(taskDataCache, resourceMap, resourceToRebalance, idealStates);
        }
        this.processCurrentStates(cache, resourceMap, resourceToRebalance, idealStates, isTaskCache);
        event.addAttribute(AttributeName.RESOURCES.name(), resourceMap);
        event.addAttribute(AttributeName.RESOURCES_TO_REBALANCE.name(), resourceToRebalance);
    }

    private void processIdealStates(BaseControllerDataProvider cache, Map<String, Resource> resourceMap, Map<String, Resource> resourceToRebalance, Map<String, IdealState> idealStates, boolean isTaskCache) {
        if (idealStates != null && idealStates.size() > 0) {
            for (IdealState idealState : idealStates.values()) {
                if (idealState == null || idealState.getNumPartitions() == 0) continue;
                Set<String> partitionSet = idealState.getPartitionSet();
                String resourceName = idealState.getResourceName();
                if (!resourceMap.containsKey(resourceName)) {
                    Resource resource = new Resource(resourceName, cache.getClusterConfig(), cache.getResourceConfig(resourceName));
                    resourceMap.put(resourceName, resource);
                    if (!(isTaskCache || idealState.isValid() && idealState.getStateModelDefRef().equals("Task"))) {
                        resourceToRebalance.put(resourceName, resource);
                    }
                    resource.setStateModelDefRef(idealState.getStateModelDefRef());
                    resource.setStateModelFactoryName(idealState.getStateModelFactoryName());
                    resource.setBucketSize(idealState.getBucketSize());
                    boolean batchMessageMode = idealState.getBatchMessageMode();
                    ClusterConfig clusterConfig = cache.getClusterConfig();
                    if (clusterConfig != null) {
                        batchMessageMode |= clusterConfig.getBatchMessageMode();
                    }
                    resource.setBatchMessageMode(batchMessageMode);
                    resource.setResourceGroupName(idealState.getResourceGroupName());
                    resource.setResourceTag(idealState.getInstanceGroupTag());
                }
                for (String partition : partitionSet) {
                    this.addPartition(partition, resourceName, resourceMap);
                }
            }
        }
    }

    private void processWorkflowConfigs(WorkflowControllerDataProvider taskDataCache, Map<String, Resource> resourceMap, Map<String, Resource> resourceToRebalance) {
        for (Map.Entry<String, WorkflowConfig> workflowConfigEntry : taskDataCache.getWorkflowConfigMap().entrySet()) {
            String resourceName = workflowConfigEntry.getKey();
            WorkflowConfig workflowConfig = workflowConfigEntry.getValue();
            this.addResourceConfigToResourceMap(resourceName, workflowConfig, taskDataCache.getClusterConfig(), resourceMap, resourceToRebalance);
            this.addPartition(resourceName, resourceName, resourceMap);
        }
    }

    private void processJobConfigs(WorkflowControllerDataProvider taskDataCache, Map<String, Resource> resourceMap, Map<String, Resource> resourceToRebalance, Map<String, IdealState> idealStates) {
        for (Map.Entry<String, JobConfig> jobConfigEntry : taskDataCache.getJobConfigMap().entrySet()) {
            String resourceName = jobConfigEntry.getKey();
            JobConfig jobConfig = jobConfigEntry.getValue();
            this.addResourceConfigToResourceMap(resourceName, jobConfig, taskDataCache.getClusterConfig(), resourceMap, resourceToRebalance);
            int numPartitions = jobConfig.getTaskConfigMap().size();
            if (numPartitions == 0 && idealStates != null) {
                IdealState targetIs = idealStates.get(jobConfig.getTargetResource());
                if (targetIs == null) {
                    LOG.debug("Target resource " + jobConfig.getTargetResource() + " does not exist for job " + resourceName);
                } else {
                    numPartitions = targetIs.getPartitionSet().size();
                }
            }
            for (int i = 0; i < numPartitions; ++i) {
                this.addPartition(resourceName + "_" + i, resourceName, resourceMap);
            }
        }
    }

    private void processCurrentStates(BaseControllerDataProvider cache, Map<String, Resource> resourceMap, Map<String, Resource> resourceToRebalance, Map<String, IdealState> idealStates, boolean isTaskCache) throws StageException {
        Map<String, LiveInstance> availableInstances = cache.getLiveInstances();
        if (availableInstances != null && availableInstances.size() > 0) {
            for (LiveInstance instance : availableInstances.values()) {
                String instanceName = instance.getInstanceName();
                String clientSessionId = instance.getEphemeralOwner();
                Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, clientSessionId, isTaskCache);
                for (CurrentState currentState : currentStateMap.values()) {
                    String resourceName = currentState.getResourceName();
                    Map<String, String> resourceStateMap = currentState.getPartitionStateMap();
                    if (resourceStateMap.keySet().isEmpty()) continue;
                    if (!resourceMap.containsKey(resourceName)) {
                        IdealState idealState;
                        Resource resource = new Resource(resourceName);
                        resource.setStateModelDefRef(currentState.getStateModelDefRef());
                        resource.setStateModelFactoryName(currentState.getStateModelFactoryName());
                        resource.setBucketSize(currentState.getBucketSize());
                        resource.setBatchMessageMode(currentState.getBatchMessageMode());
                        if (isTaskCache == "Task".equals(resource.getStateModelDefRef())) {
                            resourceToRebalance.put(resourceName, resource);
                        }
                        if ((idealState = idealStates.get(resourceName)) != null) {
                            resource.setResourceGroupName(idealState.getResourceGroupName());
                            resource.setResourceTag(idealState.getInstanceGroupTag());
                        }
                        resourceMap.put(resourceName, resource);
                    }
                    if (currentState.getStateModelDefRef() == null) {
                        LogUtil.logError(LOG, this._eventId, "state model def is null.resource:" + currentState.getResourceName() + ", partitions: " + currentState.getPartitionStateMap().keySet() + ", states: " + currentState.getPartitionStateMap().values());
                        throw new StageException("State model def is null for resource:" + currentState.getResourceName());
                    }
                    for (String partition : resourceStateMap.keySet()) {
                        this.addPartition(partition, resourceName, resourceMap);
                    }
                }
            }
        }
    }

    private void addPartition(String partition, String resourceName, Map<String, Resource> resourceMap) {
        if (resourceName == null || partition == null || resourceMap == null) {
            return;
        }
        if (!resourceMap.containsKey(resourceName)) {
            resourceMap.put(resourceName, new Resource(resourceName));
        }
        Resource resource = resourceMap.get(resourceName);
        resource.addPartition(partition);
    }

    private void addResourceConfigToResourceMap(String resourceName, ResourceConfig resourceConfig, ClusterConfig clusterConfig, Map<String, Resource> resourceMap, Map<String, Resource> resourceToRebalance) {
        Resource resource = new Resource(resourceName, clusterConfig, resourceConfig);
        resourceMap.put(resourceName, resource);
        resource.setStateModelDefRef("Task");
        resource.setStateModelFactoryName(resourceConfig.getStateModelFactoryName());
        boolean batchMessageMode = resourceConfig.getBatchMessageMode();
        if (clusterConfig != null) {
            batchMessageMode |= clusterConfig.getBatchMessageMode();
        }
        resource.setBatchMessageMode(batchMessageMode);
        resource.setResourceGroupName(resourceConfig.getResourceGroupName());
        resource.setResourceTag(resourceConfig.getInstanceGroupTag());
        resourceToRebalance.put(resourceName, resource);
    }
}

