/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.grafana.service.DashboardService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Dashboard API")
@RestController
@RequestMapping(path={"/api/grafana/dashboard"}, produces={"application/json"})
public class DashboardController {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    @Autowired
    private DashboardService dashboardService;

    @Operation(summary="Create dashboard", description="Create dashboard")
    @PostMapping
    public ResponseEntity<Message<?>> createDashboard(@RequestParam String dashboardJson, @RequestParam Long monitorId) {
        try {
            ResponseEntity<?> response = this.dashboardService.createOrUpdateDashboard(dashboardJson, monitorId);
            if (response.getStatusCode().is2xxSuccessful()) {
                return ResponseEntity.ok((Object)Message.success((String)"create dashboard success"));
            }
        }
        catch (Exception e) {
            log.error("create dashboard error", (Throwable)e);
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)e.getMessage()));
        }
        return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"create dashboard fail"));
    }

    @Operation(summary="Get dashboard by monitor id", description="Get dashboard by monitor id")
    @GetMapping
    public ResponseEntity<Message<?>> getDashboardByMonitorId(@RequestParam Long monitorId) {
        try {
            GrafanaDashboard grafanaDashboard = this.dashboardService.getDashboardByMonitorId(monitorId);
            return ResponseEntity.ok((Object)Message.success((Object)grafanaDashboard));
        }
        catch (Exception e) {
            log.error("get dashboard error", (Throwable)e);
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"get dashboard fail"));
        }
    }

    @Operation(summary="Delete dashboard by monitor id", description="Delete dashboard by monitor id")
    @DeleteMapping
    public ResponseEntity<Message<String>> deleteDashboardByMonitorId(@RequestParam Long monitorId) {
        try {
            this.dashboardService.deleteDashboard(monitorId);
        }
        catch (Exception e) {
            log.error("delete dashboard error", (Throwable)e);
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"delete dashboard fail"));
        }
        return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"delete dashboard fail"));
    }
}

