/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.IpmiAuthentication;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.None;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.RakpHmacMd5;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.RakpHmacSha1;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.RakpHmacSha256;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiAuthenticationCode implements IpmiCode.Code
{
    RAKP_NOME(0, None.class),
    RAKP_HMAC_SHA1(1, RakpHmacSha1.class),
    RAKP_HMAC_MD5(2, RakpHmacMd5.class),
    RAKP_HMAC_SHA256(3, RakpHmacSha256.class);

    private final byte code;
    private final Class<? extends IpmiAuthentication> authentication;

    private IpmiAuthenticationCode(int code, Class<? extends IpmiAuthentication> authentication) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.authentication = authentication;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public IpmiAuthentication newIpmiAuthentication() {
        if (this.authentication == null) {
            return null;
        }
        try {
            return this.authentication.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

