/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fsFactory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSFactory
implements FSFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocalFSFactory.class);

    @Override
    public File getFileWithParent(String pathname) {
        File res = new File(pathname);
        if (!res.exists()) {
            res.getParentFile().mkdirs();
        }
        return res;
    }

    @Override
    public File getFile(String pathname) {
        return new File(pathname);
    }

    @Override
    public File getFile(String parent, String child) {
        return new File(parent, child);
    }

    @Override
    public File getFile(File parent, String child) {
        return new File(parent, child);
    }

    @Override
    public File getFile(URI uri) {
        return new File(uri);
    }

    @Override
    public BufferedReader getBufferedReader(String filePath) {
        try {
            return new BufferedReader(new FileReader(filePath));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered reader for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        try {
            return new BufferedWriter(new FileWriter(filePath, append));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered writer for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String filePath) {
        try {
            return new BufferedInputStream(new FileInputStream(filePath));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered input stream for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(String filePath) {
        try {
            return new BufferedOutputStream(new FileOutputStream(filePath));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered output stream for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public void moveFile(File srcFile, File destFile) {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            logger.error("Failed to move file from {} to {}. ", new Object[]{srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e});
        }
    }

    @Override
    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        return new File(fileFolder).listFiles(file -> file.getName().endsWith(suffix));
    }

    @Override
    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        return new File(fileFolder).listFiles(file -> file.getName().startsWith(prefix));
    }

    @Override
    public boolean deleteIfExists(File file) throws IOException {
        return Files.deleteIfExists(file.toPath());
    }
}

