/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class RakpMessage1
extends AbstractSessionIpmiPayload {
    public int systemSessionId;
    public byte[] consoleRandomNumber;
    public int nameLookup = 1;
    public AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel;

    @Override
    public int getWireLength(IpmiPacketContext context) {
        String userName = context.getIpmiSession().getUserName();
        return 28 + (userName == null ? 0 : userName.length());
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        buffer.put(this.messageTag);
        RakpMessage1.reservedBytes(buffer, 3);
        this.systemSessionId = context.getIpmiSession().getSystemSessionId();
        ByteOrderUtils.writeLeInt(buffer, this.systemSessionId);
        this.consoleRandomNumber = context.getIpmiSession().getConsoleRandomNumber();
        buffer.put(this.consoleRandomNumber);
        byte t = RakpMessage1.setBits((byte)0, 4, 1, this.nameLookup);
        this.maximumPrivilegeLevel = context.getIpmiSession().getMaximumPrivilegeLevel();
        t = RakpMessage1.setBits(t, 0, 15, this.maximumPrivilegeLevel.getCode());
        buffer.put(t);
        RakpMessage1.reservedBytes(buffer, 2);
        String userName = context.getIpmiSession().getUserName();
        if (userName != null) {
            byte[] usernameBytes = userName.getBytes(StandardCharsets.US_ASCII);
            buffer.put((byte)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.RAKPMessage1;
    }
}

