/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx.kafkajmx.kafkaprocessor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.hertzbeat.collector.collect.jmx.MbeanProcessor;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;

public class KafkaReplicaManageProcessor
implements MbeanProcessor {
    private static final String FAILED_ISR_UPDATES_PER_SEC = "FailedIsrUpdatesPerSec";
    private static final String ISR_EXPANDS_PER_SEC = "IsrExpandsPerSec";
    private static final String ISR_SHRINKS_PER_SEC = "IsrShrinksPerSec";
    Boolean completeFlag = false;

    @Override
    public void preProcess(CollectRep.MetricsData.Builder builder, Metrics metrics) {
    }

    @Override
    public void process(MBeanServerConnection serverConnection, ObjectInstance objectInstance, Set<ObjectInstance> objectInstanceSet, ObjectName objectName, Map<String, String> attributeValueMap, CollectRep.ValueRow.Builder valueRowBuilder) {
        for (ObjectInstance instance : objectInstanceSet) {
            ObjectName currentObjectName = instance.getObjectName();
            try {
                Attribute attribute;
                AttributeList attributes = serverConnection.getAttributes(currentObjectName, new String[]{"Value"});
                if (FAILED_ISR_UPDATES_PER_SEC.equals(currentObjectName.getKeyProperty("name")) || ISR_EXPANDS_PER_SEC.equals(currentObjectName.getKeyProperty("name")) || ISR_SHRINKS_PER_SEC.equals(currentObjectName.getKeyProperty("name"))) {
                    attributes = serverConnection.getAttributes(currentObjectName, new String[]{"Count"});
                }
                Object value = null;
                if (attributes != null && !attributes.isEmpty() && (attribute = (Attribute)attributes.get(0)) != null) {
                    value = attribute.getValue();
                }
                String key = currentObjectName.getKeyProperty("name");
                attributeValueMap.put("Value->" + key, String.valueOf(value));
            }
            catch (IOException | InstanceNotFoundException | ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
        this.completeFlag = true;
    }

    @Override
    public Boolean isCollectionComplete() {
        return this.completeFlag;
    }
}

