/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.common.ssh;

import java.util.Collection;
import java.util.function.Function;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSshClient {
    private static final Logger log = LoggerFactory.getLogger(CommonSshClient.class);
    private static final SshClient SSH_CLIENT = SshClient.setUpDefaultClient();

    public static SshClient getSshClient() {
        return SSH_CLIENT;
    }

    static {
        AcceptAllServerKeyVerifier verifier = AcceptAllServerKeyVerifier.INSTANCE;
        SSH_CLIENT.setServerKeyVerifier((ServerKeyVerifier)verifier);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, (String)CoreModuleProperties.HEARTBEAT_INTERVAL.getName(), (int)2000);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, (String)CoreModuleProperties.HEARTBEAT_NO_REPLY_MAX.getName(), (int)30);
        PropertyResolverUtils.updateProperty((PropertyResolver)SSH_CLIENT, (String)CoreModuleProperties.SOCKET_KEEPALIVE.getName(), (boolean)true);
        SSH_CLIENT.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)false, (Collection)BuiltinDHFactories.VALUES, (Function)ClientBuilder.DH2KEX));
        SSH_CLIENT.setForwardingFilter((ForwardingFilter)new AcceptAllForwardingFilter());
        SSH_CLIENT.start();
    }
}

