/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskValidate
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskValidate.class.getName());
    private static final String QUERY_SEQ = "  select t.<q>NEXT_VAL<q>    from <q>SEQUENCE_TABLE<q> t    where t.<q>SEQUENCE_NAME<q> = ? order by t.<q>SEQUENCE_NAME<q>";
    private static final String QUERY_MAX_ID = "select max(<q>%s<q>)  from <q>%s<q>";
    private static final String QUERY_DB_LOCATION = "  select dbt.<q>DB_ID<q>,          dbt.<q>NAME<q>,          dbt.<q>DB_LOCATION_URI<q>     from <q>DBS<q> dbt order by dbt.<q>DB_ID<q> ";
    private static final String TAB_ID_RANGE_QUERY = "select max(<q>TBL_ID<q>),        min(<q>TBL_ID<q>)   from <q>TBLS<q> ";
    private static final String TAB_LOC_QUERY = "    select tbl.<q>TBL_ID<q>,            tbl.<q>TBL_NAME<q>,            sd.<q>LOCATION<q>,            dbt.<q>DB_ID<q>,            dbt.<q>NAME<q>       from <q>TBLS<q> tbl inner join <q>SDS<q> sd on sd.<q>SD_ID<q> = tbl.<q>SD_ID<q> inner join <q>DBS<q> dbt on tbl.<q>DB_ID<q> = dbt.<q>DB_ID<q>      where tbl.<q>TBL_TYPE<q> != '%s'        and tbl.<q>TBL_ID<q> >= ?        and tbl.<q>TBL_ID<q> <= ?   order by tbl.<q>TBL_ID<q> ";
    private static final int TAB_LOC_CHECK_SIZE = 2000;
    private static final String QUERY_PART_ID_RANGE = "select max(<q>PART_ID<q>),       min(<q>PART_ID<q>)  from <q>PARTITIONS<q> ";
    private static final String QUERY_PART_LOC = "    select pt.<q>PART_ID<q>,            pt.<q>PART_NAME<q>,            sd.<q>LOCATION<q>,            tbl.<q>TBL_ID<q>,            tbl.<q>TBL_NAME<q>,            dbt.<q>DB_ID<q>,            dbt.<q>NAME<q>       from <q>PARTITIONS<q> pt inner join <q>SDS<q> sd on sd.<q>SD_ID<q> = pt.<q>SD_ID<q> inner join <q>TBLS<q> tbl on tbl.<q>TBL_ID<q> = pt.<q>TBL_ID<q> inner join <q>DBS<q> dbt on dbt.<q>DB_ID<q> = tbl.<q>DB_ID<q>      where pt.<q>PART_ID<q> >= ?        and pt.<q>PART_ID<q> <= ?   order by tbl.<q>TBL_ID<q> ";
    private static final int PART_LOC_CHECK_SIZE = 2000;
    private static final String QUERY_SKEWED_COL_ID_RANGE = "select max(<q>STRING_LIST_ID_KID<q>),        min(<q>STRING_LIST_ID_KID<q>)   from <q>SKEWED_COL_VALUE_LOC_MAP<q> ";
    private static final String QUERY_SKEWED_COL_LOC = "  select t.<q>TBL_NAME<q>,          t.<q>TBL_ID<q>,          sk.<q>STRING_LIST_ID_KID<q>,          sk.<q>LOCATION<q>,          db.<q>NAME<q>,          db.<q>DB_ID<q>     from <q>TBLS<q> t     join <q>SDS<q> s on s.<q>SD_ID<q> = t.<q>SD_ID<q>     join <q>DBS<q> db on db.<q>DB_ID<q> = t.<q>DB_ID<q>     join <q>SKEWED_COL_VALUE_LOC_MAP<q> sk on sk.<q>SD_ID<q> = s.<q>SD_ID<q>    where sk.<q>STRING_LIST_ID_KID<q> >= ?      and sk.<q>STRING_LIST_ID_KID<q> <= ? order by t.<q>TBL_ID<q> ";
    private static final int SKEWED_COL_LOC_CHECK_SIZE = 2000;
    private static final String QUERY_COLUMN_NULL_VALUES = "  select t.*    from <q>TBLS<q> t   where t.<q>SD_ID<q> IS NULL     and (t.<q>TBL_TYPE<q> = '" + TableType.EXTERNAL_TABLE + "' or          t.<q>TBL_TYPE<q> = '" + TableType.MANAGED_TABLE + "') order by t.<q>TBL_ID<q> ";

    SchemaToolTaskValidate() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute() throws HiveMetaException {
        System.out.println("Starting metastore validation\n");
        Connection conn = this.schemaTool.getConnectionToMetastore(false);
        boolean success = true;
        try {
            success &= this.validateSchemaVersions();
            success &= this.validateSequences(conn);
            success &= this.validateSchemaTables(conn);
            success &= this.validateLocations(conn, this.schemaTool.getValidationServers());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new HiveMetaException("Failed to close metastore connection", (Throwable)e);
                }
            }
        }
        System.out.print("Done with metastore validation: ");
        if (!(success &= this.validateColumnNullValues(conn))) {
            System.out.println("[FAIL]");
            throw new HiveMetaException("Validation failed");
        }
        System.out.println("[SUCCESS]");
    }

    boolean validateSchemaVersions() throws HiveMetaException {
        System.out.println("Validating schema version");
        try {
            String hiveSchemaVersion = this.schemaTool.getMetaStoreSchemaInfo().getHiveSchemaVersion();
            HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo = this.schemaTool.getConnectionInfo(false);
            String newSchemaVersion = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreSchemaVersion(connectionInfo);
            this.schemaTool.assertCompatibleVersion(hiveSchemaVersion, newSchemaVersion);
        }
        catch (HiveMetaException hme) {
            if (hme.getMessage().contains("Metastore schema version is not compatible") || hme.getMessage().contains("Multiple versions were found in metastore") || hme.getMessage().contains("Could not find version info in metastore VERSION table")) {
                System.err.println(hme.getMessage());
                System.out.println("[FAIL]\n");
                return false;
            }
            throw hme;
        }
        System.out.println("[SUCCESS]\n");
        return true;
    }

    @VisibleForTesting
    boolean validateSequences(Connection conn) throws HiveMetaException {
        ImmutableMap seqNameToTable = new ImmutableMap.Builder().put((Object)"MDatabase", (Object)Pair.of((Object)"DBS", (Object)"DB_ID")).put((Object)"MRole", (Object)Pair.of((Object)"ROLES", (Object)"ROLE_ID")).put((Object)"MGlobalPrivilege", (Object)Pair.of((Object)"GLOBAL_PRIVS", (Object)"USER_GRANT_ID")).put((Object)"MTable", (Object)Pair.of((Object)"TBLS", (Object)"TBL_ID")).put((Object)"MStorageDescriptor", (Object)Pair.of((Object)"SDS", (Object)"SD_ID")).put((Object)"MSerDeInfo", (Object)Pair.of((Object)"SERDES", (Object)"SERDE_ID")).put((Object)"MColumnDescriptor", (Object)Pair.of((Object)"CDS", (Object)"CD_ID")).put((Object)"MTablePrivilege", (Object)Pair.of((Object)"TBL_PRIVS", (Object)"TBL_GRANT_ID")).put((Object)"MTableColumnStatistics", (Object)Pair.of((Object)"TAB_COL_STATS", (Object)"CS_ID")).put((Object)"MPartition", (Object)Pair.of((Object)"PARTITIONS", (Object)"PART_ID")).put((Object)"MPartitionColumnStatistics", (Object)Pair.of((Object)"PART_COL_STATS", (Object)"CS_ID")).put((Object)"MFunction", (Object)Pair.of((Object)"FUNCS", (Object)"FUNC_ID")).put((Object)"MStringList", (Object)Pair.of((Object)"SKEWED_STRING_LIST", (Object)"STRING_LIST_ID")).build();
        System.out.println("Validating sequence number for SEQUENCE_TABLE");
        boolean isValid = true;
        try {
            Statement stmt = conn.createStatement();
            for (Map.Entry e : seqNameToTable.entrySet()) {
                long maxId;
                String tableName = (String)((Pair)e.getValue()).getLeft();
                String tableKey = (String)((Pair)e.getValue()).getRight();
                String fullSequenceName = "org.apache.hadoop.hive.metastore.model." + (String)e.getKey();
                String seqQuery = this.schemaTool.quote(QUERY_SEQ);
                String maxIdQuery = String.format(this.schemaTool.quote(QUERY_MAX_ID), tableKey, tableName);
                ResultSet res = stmt.executeQuery(maxIdQuery);
                if (!res.next() || (maxId = res.getLong(1)) <= 0L) continue;
                PreparedStatement stmtSeq = conn.prepareStatement(seqQuery);
                stmtSeq.setString(1, fullSequenceName);
                ResultSet resSeq = stmtSeq.executeQuery();
                if (!resSeq.next()) {
                    isValid = false;
                    System.err.println("Missing SEQUENCE_NAME " + (String)e.getKey() + " from SEQUENCE_TABLE");
                    continue;
                }
                if (resSeq.getLong(1) >= maxId) continue;
                isValid = false;
                System.err.println("NEXT_VAL for " + (String)e.getKey() + " in SEQUENCE_TABLE < max(" + tableKey + ") in " + tableName);
            }
            System.out.println(isValid ? "[SUCCESS]\n" : "[FAIL]\n");
            return isValid;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to validate sequence number for SEQUENCE_TABLE", (Throwable)e);
        }
    }

    @VisibleForTesting
    boolean validateSchemaTables(Connection conn) throws HiveMetaException {
        System.out.println("Validating metastore schema tables");
        String version = null;
        try {
            HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo = this.schemaTool.getConnectionInfo(false);
            version = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreSchemaVersion(connectionInfo);
        }
        catch (HiveMetaException he) {
            System.err.println("Failed to determine schema version from Hive Metastore DB. " + he.getMessage());
            System.out.println("Failed in schema table validation.");
            LOG.debug("Failed to determine schema version from Hive Metastore DB," + he.getMessage(), (Throwable)he);
            return false;
        }
        Connection hmsConn = this.schemaTool.getConnectionToMetastore(false);
        LOG.debug("Validating tables in the schema for version " + version);
        ArrayList<String> dbTables = new ArrayList<String>();
        ResultSet rs = null;
        try {
            String schema = null;
            try {
                schema = hmsConn.getSchema();
            }
            catch (SQLFeatureNotSupportedException e) {
                LOG.debug("schema is not supported");
            }
            DatabaseMetaData metadata = conn.getMetaData();
            rs = metadata.getTables(null, schema, "%", new String[]{"TABLE"});
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                dbTables.add(table.toLowerCase());
                LOG.debug("Found table " + table + " in HMS dbstore");
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to retrieve schema tables from Hive Metastore DB," + e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new HiveMetaException("Failed to close resultset", (Throwable)e);
                }
            }
        }
        ArrayList<String> schemaTables = new ArrayList<String>();
        ArrayList<String> subScripts = new ArrayList<String>();
        String baseDir = new File(this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreScriptDir()).getParent();
        Object schemaFile = new File(this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreScriptDir(), this.schemaTool.getMetaStoreSchemaInfo().generateInitFileName(version)).getPath();
        try {
            LOG.debug("Parsing schema script " + (String)schemaFile);
            subScripts.addAll(this.findCreateTable((String)schemaFile, schemaTables));
            while (subScripts.size() > 0) {
                schemaFile = baseDir + "/" + this.schemaTool.getDbType() + "/" + (String)subScripts.remove(0);
                LOG.debug("Parsing subscript " + (String)schemaFile);
                subScripts.addAll(this.findCreateTable((String)schemaFile, schemaTables));
            }
        }
        catch (Exception e) {
            System.err.println("Exception in parsing schema file. Cause:" + e.getMessage());
            System.out.println("Failed in schema table validation.");
            return false;
        }
        LOG.debug("Schema tables:[ " + Arrays.toString(schemaTables.toArray()) + " ]");
        LOG.debug("DB tables:[ " + Arrays.toString(dbTables.toArray()) + " ]");
        schemaTables.removeAll(dbTables);
        if (schemaTables.size() > 0) {
            Collections.sort(schemaTables);
            System.err.println("Table(s) [ " + Arrays.toString(schemaTables.toArray()) + " ] are missing from the metastore database schema.");
            System.out.println("[FAIL]\n");
            return false;
        }
        System.out.println("[SUCCESS]\n");
        return true;
    }

    @VisibleForTesting
    List<String> findCreateTable(String path, List<String> tableList) throws Exception {
        if (!new File(path).exists()) {
            throw new Exception(path + " does not exist. Potentially incorrect version in the metastore VERSION table");
        }
        ArrayList<String> subs = new ArrayList<String>();
        HiveSchemaHelper.NestedScriptParser sp = HiveSchemaHelper.getDbCommandParser(this.schemaTool.getDbType(), false);
        Pattern regexp = Pattern.compile("CREATE TABLE(\\s+IF NOT EXISTS)?\\s+(\\S+).*");
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (sp.isNestedScript(line)) {
                    String subScript = sp.getScriptName(line);
                    LOG.debug("Schema subscript " + subScript + " found");
                    subs.add(subScript);
                    continue;
                }
                line = line.replaceAll("( )+", " ");
                line = line.replaceAll("\\(", " ");
                line = line.replaceAll("IF NOT EXISTS ", "");
                line = line.replaceAll("`", "");
                line = line.replaceAll("'", "");
                Matcher matcher = regexp.matcher(line = line.replaceAll("\"", ""));
                if (!matcher.find()) continue;
                String table = matcher.group(2);
                if (this.schemaTool.getDbType().equals("derby")) {
                    table = table.replaceAll("APP\\.", "");
                }
                tableList.add(table.toLowerCase());
                LOG.debug("Found table " + table + " in the schema");
            }
        }
        catch (IOException ex) {
            throw new Exception(ex.getMessage());
        }
        return subs;
    }

    @VisibleForTesting
    boolean validateLocations(Connection conn, URI[] defaultServers) throws HiveMetaException {
        System.out.println("Validating DFS locations");
        boolean rtn = true;
        rtn &= this.checkMetaStoreDBLocation(conn, defaultServers);
        rtn &= this.checkMetaStoreTableLocation(conn, defaultServers);
        rtn &= this.checkMetaStorePartitionLocation(conn, defaultServers);
        System.out.println((rtn &= this.checkMetaStoreSkewedColumnsLocation(conn, defaultServers)) ? "[SUCCESS]\n" : "[FAIL]\n");
        return rtn;
    }

    private boolean checkMetaStoreDBLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        String dbLocQuery = this.schemaTool.quote(QUERY_DB_LOCATION);
        int numOfInvalid = 0;
        try (Statement stmt = conn.createStatement();
             ResultSet res = stmt.executeQuery(dbLocQuery);){
            while (res.next()) {
                String locValue = res.getString(3);
                String dbName = this.getNameOrID(res, 2, 1);
                if (this.checkLocation("Database " + dbName, locValue, defaultServers)) continue;
                ++numOfInvalid;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get DB Location Info.", (Throwable)e);
        }
        return numOfInvalid == 0;
    }

    private boolean checkMetaStoreTableLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        String tabIDRangeQuery = this.schemaTool.quote(TAB_ID_RANGE_QUERY);
        String tabLocQuery = String.format(this.schemaTool.quote(TAB_LOC_QUERY), TableType.VIRTUAL_VIEW);
        try {
            long maxID = 0L;
            long minID = 0L;
            try (Statement stmt = conn.createStatement();
                 ResultSet res = stmt.executeQuery(tabIDRangeQuery);){
                if (res.next()) {
                    maxID = res.getLong(1);
                    minID = res.getLong(2);
                }
            }
            int numOfInvalid = 0;
            try (PreparedStatement pStmt = conn.prepareStatement(tabLocQuery);){
                while (minID <= maxID) {
                    pStmt.setLong(1, minID);
                    pStmt.setLong(2, minID + 2000L);
                    try (ResultSet res = pStmt.executeQuery();){
                        while (res.next()) {
                            String locValue = res.getString(3);
                            String entity = "Database " + this.getNameOrID(res, 5, 4) + ", Table " + this.getNameOrID(res, 2, 1);
                            if (this.checkLocation(entity, locValue, defaultServers)) continue;
                            ++numOfInvalid;
                        }
                    }
                    minID += 2001L;
                }
            }
            return numOfInvalid == 0;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get Table Location Info.", (Throwable)e);
        }
    }

    private boolean checkMetaStorePartitionLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        String queryPartIDRange = this.schemaTool.quote(QUERY_PART_ID_RANGE);
        String queryPartLoc = this.schemaTool.quote(QUERY_PART_LOC);
        try {
            long maxID = 0L;
            long minID = 0L;
            try (Statement stmt = conn.createStatement();
                 ResultSet res = stmt.executeQuery(queryPartIDRange);){
                if (res.next()) {
                    maxID = res.getLong(1);
                    minID = res.getLong(2);
                }
            }
            int numOfInvalid = 0;
            try (PreparedStatement pStmt = conn.prepareStatement(queryPartLoc);){
                while (minID <= maxID) {
                    pStmt.setLong(1, minID);
                    pStmt.setLong(2, minID + 2000L);
                    try (ResultSet res = pStmt.executeQuery();){
                        while (res.next()) {
                            String locValue = res.getString(3);
                            String entity = "Database " + this.getNameOrID(res, 7, 6) + ", Table " + this.getNameOrID(res, 5, 4) + ", Partition " + this.getNameOrID(res, 2, 1);
                            if (this.checkLocation(entity, locValue, defaultServers)) continue;
                            ++numOfInvalid;
                        }
                    }
                    minID += 2001L;
                }
            }
            return numOfInvalid == 0;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get Partition Location Info.", (Throwable)e);
        }
    }

    private boolean checkMetaStoreSkewedColumnsLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        String querySkewedColIDRange = this.schemaTool.quote(QUERY_SKEWED_COL_ID_RANGE);
        String querySkewedColLoc = this.schemaTool.quote(QUERY_SKEWED_COL_LOC);
        try {
            long maxID = 0L;
            long minID = 0L;
            try (Statement stmt = conn.createStatement();
                 ResultSet res = stmt.executeQuery(querySkewedColIDRange);){
                if (res.next()) {
                    maxID = res.getLong(1);
                    minID = res.getLong(2);
                }
            }
            int numOfInvalid = 0;
            try (PreparedStatement pStmt = conn.prepareStatement(querySkewedColLoc);){
                while (minID <= maxID) {
                    pStmt.setLong(1, minID);
                    pStmt.setLong(2, minID + 2000L);
                    try (ResultSet res = pStmt.executeQuery();){
                        while (res.next()) {
                            String locValue = res.getString(4);
                            String entity = "Database " + this.getNameOrID(res, 5, 6) + ", Table " + this.getNameOrID(res, 1, 2) + ", String list " + res.getString(3);
                            if (this.checkLocation(entity, locValue, defaultServers)) continue;
                            ++numOfInvalid;
                        }
                    }
                    minID += 2001L;
                }
            }
            return numOfInvalid == 0;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get skewed columns location info.", (Throwable)e);
        }
    }

    private boolean checkLocation(String entity, String entityLocation, URI[] defaultServers) {
        boolean isValid = true;
        if (entityLocation == null) {
            System.err.println(entity + ", Error: empty location");
            isValid = false;
        } else {
            try {
                URI currentUri = new Path(entityLocation).toUri();
                String scheme = currentUri.getScheme();
                String path = currentUri.getPath();
                if (StringUtils.isEmpty((CharSequence)scheme)) {
                    System.err.println(entity + ", Location: " + entityLocation + ", Error: missing location scheme.");
                    isValid = false;
                } else if (StringUtils.isEmpty((CharSequence)path)) {
                    System.err.println(entity + ", Location: " + entityLocation + ", Error: missing location path.");
                    isValid = false;
                } else if (ArrayUtils.isNotEmpty((Object[])defaultServers) && currentUri.getAuthority() != null) {
                    String authority = currentUri.getAuthority();
                    boolean matchServer = false;
                    for (URI server : defaultServers) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)server.getScheme(), (CharSequence)scheme) || !StringUtils.equalsIgnoreCase((CharSequence)server.getAuthority(), (CharSequence)authority)) continue;
                        matchServer = true;
                        break;
                    }
                    if (!matchServer) {
                        System.err.println(entity + ", Location: " + entityLocation + ", Error: mismatched server.");
                        isValid = false;
                    }
                }
                if (isValid && StringUtils.containsOnly((CharSequence)path, (String)"/")) {
                    System.err.println(entity + ", Location: " + entityLocation + ", Warn: location set to root, not a recommended config.");
                }
            }
            catch (Exception pe) {
                System.err.println(entity + ", Error: invalid location - " + pe.getMessage());
                isValid = false;
            }
        }
        return isValid;
    }

    private String getNameOrID(ResultSet res, int nameInx, int idInx) throws SQLException {
        String itemName = res.getString(nameInx);
        return itemName == null || itemName.isEmpty() ? "ID: " + res.getString(idInx) : "Name: " + itemName;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    boolean validateColumnNullValues(Connection conn) throws HiveMetaException {
        System.out.println("Validating columns for incorrect NULL values.");
        boolean isValid = true;
        String queryColumnNullValues = this.schemaTool.quote(QUERY_COLUMN_NULL_VALUES);
        try (Statement stmt = conn.createStatement();){
            boolean bl;
            block15: {
                ResultSet res = stmt.executeQuery(queryColumnNullValues);
                try {
                    while (res.next()) {
                        long tableId = res.getLong("TBL_ID");
                        String tableName = res.getString("TBL_NAME");
                        String tableType = res.getString("TBL_TYPE");
                        isValid = false;
                        System.err.println("SD_ID in TBLS should not be NULL for Table Name=" + tableName + ", Table ID=" + tableId + ", Table Type=" + tableType);
                    }
                    System.out.println(isValid ? "[SUCCESS]\n" : "[FAIL]\n");
                    bl = isValid;
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to validate columns for incorrect NULL values", (Throwable)e);
        }
    }
}

