/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import org.datanucleus.flush.SCOOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.Store;

public class MapClearOperation
implements SCOOperation {
    final DNStateManager sm;
    final int fieldNumber;
    final MapStore store;

    public MapClearOperation(DNStateManager sm, MapStore store) {
        this.sm = sm;
        this.fieldNumber = store.getOwnerMemberMetaData().getAbsoluteFieldNumber();
        this.store = store;
    }

    public MapClearOperation(DNStateManager sm, int fieldNum) {
        this.sm = sm;
        this.fieldNumber = fieldNum;
        this.store = null;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.store != null ? this.store.getOwnerMemberMetaData() : this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumber);
    }

    @Override
    public void perform() {
        if (this.store != null) {
            this.store.clear(this.sm);
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public DNStateManager getStateManager() {
        return this.sm;
    }

    public String toString() {
        return "MAP CLEAR : " + this.sm + " field=" + this.getMemberMetaData().getName();
    }
}

