/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractQueryResultsCache
implements QueryResultsCache {
    private static final long serialVersionUID = 5815194081248492071L;
    protected NucleusContext nucleusCtx;
    protected int maxSize = -1;
    protected boolean clearAtClose = true;
    protected long expiryMillis = -1L;
    protected String cacheName;

    public AbstractQueryResultsCache(NucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
        Configuration conf = nucleusCtx.getConfiguration();
        this.maxSize = conf.getIntProperty(PropertyNames.PROPERTY_CACHE_QUERYRESULTS_MAXSIZE);
        this.clearAtClose = conf.getBooleanProperty(PropertyNames.PROPERTY_CACHE_QUERYRESULTS_CLEARATCLOSE, true);
        if (conf.hasProperty(PropertyNames.PROPERTY_CACHE_QUERYRESULTS_EXPIRY_MILLIS)) {
            this.expiryMillis = conf.getIntProperty(PropertyNames.PROPERTY_CACHE_QUERYRESULTS_EXPIRY_MILLIS);
        }
        this.cacheName = conf.getStringProperty(PropertyNames.PROPERTY_CACHE_QUERYRESULTS_NAME);
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn("No property " + PropertyNames.PROPERTY_CACHE_QUERYRESULTS_NAME + " specified so using name of 'DataNucleus-Query'");
            this.cacheName = "DataNucleus-Query";
        }
    }
}

