/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.execute;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.execute.AlterTableExecuteDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={875})
public class AlterTableExecuteAnalyzer
extends AbstractAlterTableAnalyzer {
    private static final Pattern EXPIRE_SNAPSHOT_BY_ID_REGEX = Pattern.compile("\\d+(\\s*,\\s*\\d+)*");

    public AlterTableExecuteAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        ASTNode executeCommandType = (ASTNode)command.getChild(0);
        this.validateAlterTableType(table, AlterTableType.EXECUTE, false);
        this.inputs.add(new ReadEntity(table));
        AlterTableExecuteDesc desc = null;
        switch (executeCommandType.getType()) {
            case 309: {
                desc = AlterTableExecuteAnalyzer.getRollbackDesc(tableName, partitionSpec, (ASTNode)command.getChild(1));
                break;
            }
            case 140: {
                desc = AlterTableExecuteAnalyzer.getExpireSnapshotDesc(tableName, partitionSpec, command.getChildren(), this.queryState.getConf());
                break;
            }
            case 325: {
                desc = AlterTableExecuteAnalyzer.getSetCurrentSnapshotDesc(tableName, partitionSpec, (ASTNode)command.getChild(1));
                break;
            }
            case 148: {
                desc = AlterTableExecuteAnalyzer.getFastForwardDesc(tableName, partitionSpec, command);
                break;
            }
            case 67: {
                desc = AlterTableExecuteAnalyzer.getCherryPickDesc(tableName, partitionSpec, (ASTNode)command.getChild(1));
                break;
            }
            case 249: {
                desc = AlterTableExecuteAnalyzer.getDeleteOrphanFilesDesc(tableName, partitionSpec, command.getChildren());
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private static AlterTableExecuteDesc getCherryPickDesc(TableName tableName, Map<String, String> partitionSpec, ASTNode childNode) throws SemanticException {
        long snapshotId = Long.parseLong(childNode.getText());
        AlterTableExecuteSpec<AlterTableExecuteSpec.CherryPickSpec> spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.CherryPickSpec>(AlterTableExecuteSpec.ExecuteOperationType.CHERRY_PICK, new AlterTableExecuteSpec.CherryPickSpec(snapshotId));
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static AlterTableExecuteDesc getFastForwardDesc(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String targetBranchName;
        String branchName;
        ASTNode child1 = (ASTNode)command.getChild(1);
        if (command.getChildCount() == 2) {
            branchName = "main";
            targetBranchName = PlanUtils.stripQuotes(child1.getText());
        } else {
            ASTNode child2 = (ASTNode)command.getChild(2);
            branchName = PlanUtils.stripQuotes(child1.getText());
            targetBranchName = PlanUtils.stripQuotes(child2.getText());
        }
        AlterTableExecuteSpec<AlterTableExecuteSpec.FastForwardSpec> spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.FastForwardSpec>(AlterTableExecuteSpec.ExecuteOperationType.FAST_FORWARD, new AlterTableExecuteSpec.FastForwardSpec(branchName, targetBranchName));
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static AlterTableExecuteDesc getSetCurrentSnapshotDesc(TableName tableName, Map<String, String> partitionSpec, ASTNode childNode) throws SemanticException {
        AlterTableExecuteSpec<AlterTableExecuteSpec.SetCurrentSnapshotSpec> spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.SetCurrentSnapshotSpec>(AlterTableExecuteSpec.ExecuteOperationType.SET_CURRENT_SNAPSHOT, new AlterTableExecuteSpec.SetCurrentSnapshotSpec(childNode.getText()));
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static AlterTableExecuteDesc getExpireSnapshotDesc(TableName tableName, Map<String, String> partitionSpec, List<Node> children, HiveConf conf) throws SemanticException {
        AlterTableExecuteSpec<AlterTableExecuteSpec.ExpireSnapshotsSpec> spec;
        if (children.size() == 1) {
            AlterTableExecuteSpec<Object> spec2 = new AlterTableExecuteSpec<Object>(AlterTableExecuteSpec.ExecuteOperationType.EXPIRE_SNAPSHOT, null);
            return new AlterTableExecuteDesc(tableName, partitionSpec, spec2);
        }
        ZoneId timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
        ASTNode firstNode = (ASTNode)children.get(1);
        String firstNodeText = PlanUtils.stripQuotes(firstNode.getText().trim());
        if (firstNode.getType() == 301) {
            ASTNode numRetainLastNode = (ASTNode)children.get(2);
            String numToRetainText = PlanUtils.stripQuotes(numRetainLastNode.getText());
            int numToRetain = Integer.parseInt(numToRetainText);
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.ExpireSnapshotsSpec>(AlterTableExecuteSpec.ExecuteOperationType.EXPIRE_SNAPSHOT, new AlterTableExecuteSpec.ExpireSnapshotsSpec(numToRetain));
        } else if (children.size() == 3) {
            ASTNode secondNode = (ASTNode)children.get(2);
            String secondNodeText = PlanUtils.stripQuotes(secondNode.getText().trim());
            TimestampTZ fromTime = TimestampTZUtil.parse((String)AlterTableExecuteAnalyzer.getTimeStampString(conf, firstNode, firstNodeText), (ZoneId)timeZone);
            TimestampTZ toTime = TimestampTZUtil.parse((String)AlterTableExecuteAnalyzer.getTimeStampString(conf, secondNode, secondNodeText), (ZoneId)timeZone);
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.ExpireSnapshotsSpec>(AlterTableExecuteSpec.ExecuteOperationType.EXPIRE_SNAPSHOT, new AlterTableExecuteSpec.ExpireSnapshotsSpec(fromTime.toEpochMilli(), toTime.toEpochMilli()));
        } else if (EXPIRE_SNAPSHOT_BY_ID_REGEX.matcher(firstNodeText).matches()) {
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.ExpireSnapshotsSpec>(AlterTableExecuteSpec.ExecuteOperationType.EXPIRE_SNAPSHOT, new AlterTableExecuteSpec.ExpireSnapshotsSpec(firstNodeText));
        } else {
            TimestampTZ time = TimestampTZUtil.parse((String)AlterTableExecuteAnalyzer.getTimeStampString(conf, firstNode, firstNodeText), (ZoneId)timeZone);
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.ExpireSnapshotsSpec>(AlterTableExecuteSpec.ExecuteOperationType.EXPIRE_SNAPSHOT, new AlterTableExecuteSpec.ExpireSnapshotsSpec(time.toEpochMilli()));
        }
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static String getTimeStampString(HiveConf conf, ASTNode node, String nodeText) throws SemanticException {
        if (node.getChildCount() > 0) {
            QueryState queryState = new QueryState.Builder().withGenerateNewQueryId(false).withHiveConf(conf).build();
            SemanticAnalyzer sem = (SemanticAnalyzer)SemanticAnalyzerFactory.get(queryState, node);
            ExprNodeDesc desc = sem.genExprNodeDesc(node, new RowResolver(), false, true);
            if (!(desc instanceof ExprNodeConstantDesc)) {
                throw new SemanticException("Invalid timestamp expression");
            }
            ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)desc;
            return String.valueOf(constantDesc.getValue());
        }
        return nodeText;
    }

    private static AlterTableExecuteDesc getRollbackDesc(TableName tableName, Map<String, String> partitionSpec, ASTNode childNode) throws SemanticException {
        AlterTableExecuteSpec<AlterTableExecuteSpec.RollbackSpec> spec;
        if (childNode.getType() == 436) {
            ZoneId timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
            TimestampTZ time = TimestampTZUtil.parse((String)PlanUtils.stripQuotes(childNode.getText()), (ZoneId)timeZone);
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.RollbackSpec>(AlterTableExecuteSpec.ExecuteOperationType.ROLLBACK, new AlterTableExecuteSpec.RollbackSpec(AlterTableExecuteSpec.RollbackSpec.RollbackType.TIME, time.toEpochMilli()));
        } else {
            spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.RollbackSpec>(AlterTableExecuteSpec.ExecuteOperationType.ROLLBACK, new AlterTableExecuteSpec.RollbackSpec(AlterTableExecuteSpec.RollbackSpec.RollbackType.VERSION, Long.valueOf(childNode.getText())));
        }
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static AlterTableExecuteDesc getDeleteOrphanFilesDesc(TableName tableName, Map<String, String> partitionSpec, List<Node> children) throws SemanticException {
        long time = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(3L);
        if (children.size() == 2) {
            time = AlterTableExecuteAnalyzer.getTimeStampMillis((ASTNode)children.get(1));
        }
        AlterTableExecuteSpec<AlterTableExecuteSpec.DeleteOrphanFilesDesc> spec = new AlterTableExecuteSpec<AlterTableExecuteSpec.DeleteOrphanFilesDesc>(AlterTableExecuteSpec.ExecuteOperationType.DELETE_ORPHAN_FILES, new AlterTableExecuteSpec.DeleteOrphanFilesDesc(time));
        return new AlterTableExecuteDesc(tableName, partitionSpec, spec);
    }

    private static long getTimeStampMillis(ASTNode childNode) {
        String childNodeText = PlanUtils.stripQuotes(childNode.getText());
        ZoneId timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
        TimestampTZ time = TimestampTZUtil.parse((String)PlanUtils.stripQuotes(childNodeText), (ZoneId)timeZone);
        return time.toEpochMilli();
    }
}

