/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.Frameworks;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild.MaterializedViewASTBuilder;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild.NativeAcidMaterializedViewASTBuilder;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild.NonNativeAcidMaterializedViewASTBuilder;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTezModelRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInBetweenExpandRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSearchRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAggregateInsertDeleteIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAggregateInsertIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAggregatePartitionIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveInsertOnlyScanWriteIdRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveJoinInsertIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HivePushdownSnapshotFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewRewritingRelVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveIncrementalRelMdRowCount;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DDLSemanticAnalyzerFactory.DDLType(types={908})
public class AlterMaterializedViewRebuildAnalyzer
extends CalcitePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(AlterMaterializedViewRebuildAnalyzer.class);
    protected Table mvTable;
    private static final String REWRITTEN_INSERT_STATEMENT = "INSERT OVERWRITE TABLE %s %s";

    public AlterMaterializedViewRebuildAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.NONE) {
            super.analyzeInternal(root);
            return;
        }
        ASTNode tableTree = (ASTNode)root.getChild(0);
        TableName tableName = AlterMaterializedViewRebuildAnalyzer.getQualifiedTableName(tableTree);
        if (this.ctx.isScheduledQuery()) {
            this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
            return;
        }
        try {
            this.mvTable = this.db.getTable(tableName.getDb(), tableName.getTable());
            Boolean outdated = this.db.isOutdatedMaterializedView(this.queryState::getValidTxnList, this.getTxnMgr(), this.mvTable);
            if (outdated != null && !outdated.booleanValue()) {
                String msg = String.format("Materialized view %s.%s is up to date. Skipping rebuild.", tableName.getDb(), tableName.getTable());
                LOG.info(msg);
                this.console.printInfo(msg, false);
                return;
            }
        }
        catch (HiveException e) {
            LOG.warn("Error while checking materialized view " + tableName.getDb() + "." + tableName.getTable(), (Throwable)e);
        }
        ASTNode rewrittenAST = this.getRewrittenAST(tableName);
        this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD;
        LOG.debug("Rebuilding materialized view " + tableName.getNotEmptyDbTable());
        super.analyzeInternal(rewrittenAST);
        this.queryState.setCommandType(HiveOperation.ALTER_MATERIALIZED_VIEW_REBUILD);
    }

    private ASTNode getRewrittenAST(TableName tableName) throws SemanticException {
        ASTNode rewrittenAST;
        block7: {
            try {
                LockState state;
                Table table = this.getTableObjectByName(tableName.getNotEmptyDbTable(), true);
                if (!table.isMaterializedView()) {
                    throw new SemanticException(ErrorMsg.REBUILD_NO_MATERIALIZED_VIEW, new String[0]);
                }
                String viewText = table.getViewExpandedText();
                if (viewText.trim().isEmpty()) {
                    throw new SemanticException(ErrorMsg.MATERIALIZED_VIEW_DEF_EMPTY, new String[0]);
                }
                Context ctx = new Context((Configuration)this.queryState.getConf());
                String rewrittenInsertStatement = String.format(REWRITTEN_INSERT_STATEMENT, tableName.getEscapedNotEmptyDbTable(), viewText);
                rewrittenAST = ParseUtils.parse(rewrittenInsertStatement, ctx);
                this.ctx.addSubContext(ctx);
                if (this.ctx.isExplainPlan() || !AcidUtils.isTransactionalTable(table) && (!table.isNonNative() || !table.getStorageHandler().areSnapshotsSupported())) break block7;
                HiveTxnManager txnManager = this.getTxnMgr();
                try {
                    state = txnManager.acquireMaterializationRebuildLock(tableName.getDb(), tableName.getTable(), txnManager.getCurrentTxnId()).getState();
                }
                catch (LockException e) {
                    throw new SemanticException("Exception acquiring lock for rebuilding the materialized view", (Throwable)((Object)e));
                }
                if (state != LockState.ACQUIRED) {
                    throw new SemanticException("Another process is rebuilding the materialized view " + tableName.getNotEmptyDbTable());
                }
            }
            catch (Exception e) {
                throw new SemanticException((Throwable)e);
            }
        }
        return rewrittenAST;
    }

    @Override
    protected Frameworks.PlannerAction<RelNode> createPlannerAction(Map<String, PrunedPartitionList> partitionCache, StatsSource statsSource, ColumnAccessInfo columnAccessInfo) {
        return new MVRebuildCalcitePlannerAction(partitionCache, statsSource, columnAccessInfo);
    }

    @Override
    protected ASTNode fixUpAfterCbo(ASTNode originalAst, ASTNode newAst, CalcitePlanner.PreCboCtx cboCtx) throws SemanticException {
        ASTNode fixedAST = super.fixUpAfterCbo(originalAst, newAst, cboCtx);
        switch (this.mvRebuildMode) {
            case INSERT_OVERWRITE_REBUILD: {
                return fixedAST;
            }
            case JOIN_INSERT_REBUILD: {
                this.fixUpASTJoinInsertIncrementalRebuild(fixedAST);
                return fixedAST;
            }
            case AGGREGATE_INSERT_REBUILD: {
                this.fixUpASTAggregateInsertIncrementalRebuild(fixedAST, this.getMaterializedViewASTBuilder());
                return fixedAST;
            }
            case AGGREGATE_INSERT_DELETE_REBUILD: {
                this.fixUpASTAggregateInsertDeleteIncrementalRebuild(fixedAST, this.getMaterializedViewASTBuilder());
                return fixedAST;
            }
        }
        throw new UnsupportedOperationException("No materialized view rebuild exists for mode " + this.mvRebuildMode);
    }

    @NotNull
    private MaterializedViewASTBuilder getMaterializedViewASTBuilder() {
        if (AcidUtils.isFullAcidTable(this.mvTable.getTTable())) {
            return new NativeAcidMaterializedViewASTBuilder();
        }
        if (AcidUtils.isNonNativeAcidTable(this.mvTable)) {
            return new NonNativeAcidMaterializedViewASTBuilder(this.mvTable);
        }
        throw new UnsupportedOperationException("Incremental rebuild is supported only for fully ACID materialized views or if the Storage handler supports snapshots (Iceberg).");
    }

    private void fixUpASTAggregateInsertIncrementalRebuild(ASTNode newAST, MaterializedViewASTBuilder astBuilder) throws SemanticException {
        ASTNode updateNode = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newAST, 1155, 1055);
        ASTNode subqueryNodeInputROJ = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newAST, 1155, 1032, 1183, 1236);
        ASTNode whereClauseInUpdate = this.findWhereClause(updateNode);
        HashMap<Context.DestClausePrefix, ASTNode> disjunctMap = new HashMap<Context.DestClausePrefix, ASTNode>(Context.DestClausePrefix.values().length);
        if (whereClauseInUpdate.getChild(0).getChild(0).getType() == 16) {
            disjunctMap.put(Context.DestClausePrefix.UPDATE, (ASTNode)whereClauseInUpdate.getChild(0).getChild(0));
            disjunctMap.put(Context.DestClausePrefix.INSERT, (ASTNode)whereClauseInUpdate.getChild(0).getChild(1));
        } else if (whereClauseInUpdate.getChild(0).getChild(1).getType() == 16) {
            disjunctMap.put(Context.DestClausePrefix.INSERT, (ASTNode)whereClauseInUpdate.getChild(0).getChild(0));
            disjunctMap.put(Context.DestClausePrefix.UPDATE, (ASTNode)whereClauseInUpdate.getChild(0).getChild(1));
        } else {
            throw new SemanticException("Unexpected condition in incremental rewriting");
        }
        this.fixUpASTAggregateIncrementalRebuild(subqueryNodeInputROJ, updateNode, disjunctMap, astBuilder);
    }

    private void fixUpASTAggregateIncrementalRebuild(ASTNode subqueryNodeInputROJ, ASTNode updateInsertNode, Map<Context.DestClausePrefix, ASTNode> disjuncts, MaterializedViewASTBuilder astBuilder) throws SemanticException {
        ASTNode destinationNode = (ASTNode)updateInsertNode.getChild(0);
        ASTNode newInsertInto = (ASTNode)ParseDriver.adaptor.create(1056, "TOK_INSERT_INTO");
        newInsertInto.addChildren(destinationNode.getChildren());
        ASTNode destinationParentNode = (ASTNode)destinationNode.getParent();
        int childIndex = destinationNode.childIndex;
        destinationParentNode.deleteChild(childIndex);
        destinationParentNode.insertChild(childIndex, (Object)newInsertInto);
        ASTNode materializationNode = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newInsertInto, 1056, 1243, 1273);
        ASTNode updateParent = (ASTNode)updateInsertNode.getParent();
        ASTNode insertNode = (ASTNode)ParseDriver.adaptor.dupTree((Object)updateInsertNode);
        insertNode.setParent((Tree)updateParent);
        ASTNode selectNodeInputROJ = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(subqueryNodeInputROJ, 1236, 1155, 1055, 1190);
        astBuilder.appendDeleteSelectNodes(selectNodeInputROJ, TableName.getDbTable((String)materializationNode.getChild(0).getText(), (String)materializationNode.getChild(1).getText()));
        ASTNode whereClauseInUpdate = this.findWhereClause(updateInsertNode);
        if (whereClauseInUpdate.getChild(0).getType() != 246) {
            throw new SemanticException("OR clause expected below TOK_WHERE in incremental rewriting");
        }
        ParseDriver.adaptor.setChild((Object)whereClauseInUpdate, 0, (Object)disjuncts.get((Object)Context.DestClausePrefix.UPDATE));
        ASTNode updateDeleteNode = (ASTNode)ParseDriver.adaptor.dupTree((Object)updateInsertNode);
        ASTNode selectNodeInUpdateDelete = (ASTNode)updateDeleteNode.getChild(1);
        if (selectNodeInUpdateDelete.getType() != 1190) {
            throw new SemanticException("TOK_SELECT expected in incremental rewriting got " + selectNodeInUpdateDelete.getType());
        }
        while (selectNodeInUpdateDelete.getChildCount() > 0) {
            selectNodeInUpdateDelete.deleteChild(0);
        }
        List<ASTNode> selectExprNodesInUpdate = astBuilder.createDeleteSelectNodes(subqueryNodeInputROJ.getChild(1).getText());
        for (int i = 0; i < selectExprNodesInUpdate.size(); ++i) {
            selectNodeInUpdateDelete.insertChild(i, (Object)selectExprNodesInUpdate.get(i));
        }
        ASTNode sortExprNode = astBuilder.createSortNodes(astBuilder.createAcidSortNodes((ASTNode)subqueryNodeInputROJ.getChild(1)));
        ParseDriver.adaptor.addChild((Object)updateDeleteNode, (Object)sortExprNode);
        ASTNode whereClauseInInsert = this.findWhereClause(insertNode);
        if (whereClauseInInsert.getChild(0).getType() != 246) {
            throw new SemanticException("OR clause expected below TOK_WHERE in incremental rewriting");
        }
        ParseDriver.adaptor.setChild((Object)whereClauseInInsert, 0, (Object)disjuncts.get((Object)Context.DestClausePrefix.INSERT));
        updateParent.addChild((Tree)updateDeleteNode);
        updateParent.addChild((Tree)insertNode);
        this.ctx.setOperation(Context.Operation.MERGE);
        this.ctx.addDestNamePrefix(1, Context.DestClausePrefix.INSERT);
        this.ctx.addDestNamePrefix(2, Context.DestClausePrefix.DELETE);
        this.ctx.addDestNamePrefix(3, Context.DestClausePrefix.INSERT);
    }

    private void fixUpASTAggregateInsertDeleteIncrementalRebuild(ASTNode newAST, MaterializedViewASTBuilder astBuilder) throws SemanticException {
        ASTNode updateNode = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newAST, 1155, 1055);
        ASTNode subqueryNodeInputROJ = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newAST, 1155, 1032, 1183, 1236);
        ASTNode whereClauseInUpdate = this.findWhereClause(updateNode);
        ASTNode[] disjuncts = new ASTNode[]{(ASTNode)whereClauseInUpdate.getChild(0).getChild(0), (ASTNode)whereClauseInUpdate.getChild(0).getChild(1).getChild(0), (ASTNode)whereClauseInUpdate.getChild(0).getChild(1).getChild(1)};
        HashMap<Context.DestClausePrefix, ASTNode> disjunctMap = new HashMap<Context.DestClausePrefix, ASTNode>(Context.DestClausePrefix.values().length);
        for (ASTNode disjunct : disjuncts) {
            if (disjunct.getChild(0).getType() == 1035 && disjunct.getChild(0).getChild(0).getType() == 24 && "isnull".equals(disjunct.getChild(0).getChild(0).getText())) {
                disjunctMap.put(Context.DestClausePrefix.INSERT, disjunct);
                continue;
            }
            if (disjunct.getChild(0).getType() != 1035 && new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(disjunct, 36, 246, 36, 18) != null) {
                disjunctMap.put(Context.DestClausePrefix.DELETE, disjunct);
                continue;
            }
            if (disjunct.getChild(0).getType() != 1035 && new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(disjunct, 36, 246, 36, 21) != null) {
                disjunctMap.put(Context.DestClausePrefix.UPDATE, disjunct);
                continue;
            }
            throw new SemanticException("Unexpected condition in incremental rewriting");
        }
        this.fixUpASTAggregateIncrementalRebuild(subqueryNodeInputROJ, updateNode, disjunctMap, astBuilder);
        this.addDeleteBranch(updateNode, subqueryNodeInputROJ, (ASTNode)disjunctMap.get((Object)Context.DestClausePrefix.DELETE), astBuilder);
        this.ctx.addDestNamePrefix(4, Context.DestClausePrefix.DELETE);
    }

    private ASTNode findWhereClause(ASTNode updateNode) throws SemanticException {
        ASTNode whereClauseInUpdate = null;
        for (int i = 0; i < updateNode.getChildren().size(); ++i) {
            if (updateNode.getChild(i).getType() != 1316) continue;
            whereClauseInUpdate = (ASTNode)updateNode.getChild(i);
            break;
        }
        if (whereClauseInUpdate == null) {
            throw new SemanticException("TOK_WHERE expected in incremental rewriting");
        }
        return whereClauseInUpdate;
    }

    private void addDeleteBranch(ASTNode updateNode, ASTNode subqueryNodeInputROJ, ASTNode predicate, MaterializedViewASTBuilder astBuilder) throws SemanticException {
        ASTNode updateParent = (ASTNode)updateNode.getParent();
        ASTNode deleteNode = (ASTNode)ParseDriver.adaptor.dupTree((Object)updateNode);
        deleteNode.setParent((Tree)updateParent);
        updateParent.addChild((Tree)deleteNode);
        ASTNode selectNodeInDelete = (ASTNode)deleteNode.getChild(1);
        if (selectNodeInDelete.getType() != 1190) {
            throw new SemanticException("TOK_SELECT expected in incremental rewriting");
        }
        while (selectNodeInDelete.getChildCount() > 0) {
            selectNodeInDelete.deleteChild(0);
        }
        astBuilder.createDeleteSelectNodes(subqueryNodeInputROJ.getChild(1).getText()).forEach(astNode -> ParseDriver.adaptor.addChild((Object)selectNodeInDelete, astNode));
        ASTNode whereClauseInDelete = this.findWhereClause(deleteNode);
        ParseDriver.adaptor.setChild((Object)whereClauseInDelete, 0, (Object)predicate);
    }

    private void fixUpASTJoinInsertIncrementalRebuild(ASTNode newAST) throws SemanticException {
        ASTNode dest = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(newAST, 1155, 1055, 994);
        ASTNode newChild = (ASTNode)ParseDriver.adaptor.create(1056, "TOK_INSERT_INTO");
        newChild.addChildren(dest.getChildren());
        ASTNode destParent = (ASTNode)dest.getParent();
        int childIndex = dest.childIndex;
        destParent.deleteChild(childIndex);
        destParent.insertChild(childIndex, (Object)newChild);
    }

    @Override
    protected boolean allowOutputMultipleTimes() {
        return true;
    }

    @Override
    public void setQueryType(ASTNode tree) {
        this.queryProperties.setQueryType(QueryProperties.QueryType.DDL);
    }

    @Override
    protected void setSqlKind(SqlKind sqlKind) {
    }

    protected class MVRebuildCalcitePlannerAction
    extends CalcitePlanner.CalcitePlannerAction {
        public MVRebuildCalcitePlannerAction(Map<String, PrunedPartitionList> partitionCache, StatsSource statsSource, ColumnAccessInfo columnAccessInfo) {
            super(AlterMaterializedViewRebuildAnalyzer.this, partitionCache, statsSource, columnAccessInfo, AlterMaterializedViewRebuildAnalyzer.this.getQB());
        }

        @Override
        protected RelNode applyMaterializedViewRewriting(RelOptPlanner planner, RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            HiveRelOptMaterialization materialization;
            RelOptCluster optCluster = basePlan.getCluster();
            PerfLogger perfLogger = SessionState.getPerfLogger();
            RelNode calcitePreMVRewritingPlan = basePlan;
            Set<TableName> tablesUsedQuery = this.getTablesUsed(basePlan);
            try {
                materialization = AlterMaterializedViewRebuildAnalyzer.this.db.getMaterializedViewForRebuild(AlterMaterializedViewRebuildAnalyzer.this.mvTable.getDbName(), AlterMaterializedViewRebuildAnalyzer.this.mvTable.getTableName(), tablesUsedQuery, AlterMaterializedViewRebuildAnalyzer.this.queryState::getValidTxnList, AlterMaterializedViewRebuildAnalyzer.this.getTxnMgr());
                if (materialization == null) {
                    return calcitePreMVRewritingPlan;
                }
                materialization = materialization.copyToNewCluster(optCluster);
            }
            catch (HiveException e) {
                LOG.warn("Exception loading materialized views", (Throwable)e);
                return calcitePreMVRewritingPlan;
            }
            perfLogger.perfLogBegin(this.getClass().getName(), "optimizer");
            HepProgramBuilder program = new HepProgramBuilder();
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveInBetweenExpandRule.FILTER_INSTANCE, HiveInBetweenExpandRule.JOIN_INSTANCE, HiveInBetweenExpandRule.PROJECT_INSTANCE);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            program = new HepProgramBuilder();
            this.generatePartialProgram(program, true, HepMatchOrder.TOP_DOWN, HiveMaterializedViewRule.MATERIALIZED_VIEW_REWRITING_RULES);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider, Collections.singletonList(materialization));
            program = new HepProgramBuilder();
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, HiveSearchRules.FILTER_SEARCH_EXPAND, HivePushdownSnapshotFilterRule.INSTANCE);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            perfLogger.perfLogEnd(this.getClass().getName(), "optimizer", "Calcite: View-based rewriting");
            List<Table> materializedViewsUsedOriginalPlan = this.getMaterializedViewsUsed(calcitePreMVRewritingPlan);
            List<Table> materializedViewsUsedAfterRewrite = this.getMaterializedViewsUsed(basePlan);
            if (materializedViewsUsedOriginalPlan.size() == materializedViewsUsedAfterRewrite.size()) {
                return calcitePreMVRewritingPlan;
            }
            try {
                if (!HiveMaterializedViewUtils.checkPrivilegeForMaterializedViews(materializedViewsUsedAfterRewrite)) {
                    return calcitePreMVRewritingPlan;
                }
            }
            catch (HiveException e) {
                LOG.warn("Exception checking privileges for materialized views", (Throwable)e);
                return calcitePreMVRewritingPlan;
            }
            if (HiveConf.getBoolVar((Configuration)AlterMaterializedViewRebuildAnalyzer.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL)) {
                if (materialization.isSourceTablesCompacted()) {
                    return calcitePreMVRewritingPlan;
                }
                RelNode incrementalRebuildPlan = this.applyRecordIncrementalRebuildPlan(basePlan, mdProvider, executorProvider, optCluster, calcitePreMVRewritingPlan, materialization);
                if (AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD) {
                    return incrementalRebuildPlan;
                }
                return this.applyPartitionIncrementalRebuildPlan(basePlan, mdProvider, executorProvider, materialization, optCluster, calcitePreMVRewritingPlan);
            }
            return this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
        }

        private RelNode applyRecordIncrementalRebuildPlan(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider, RelOptCluster optCluster, RelNode calcitePreMVRewritingPlan, HiveRelOptMaterialization materialization) {
            boolean acidView = AcidUtils.isFullAcidTable(AlterMaterializedViewRebuildAnalyzer.this.mvTable.getTTable()) || AcidUtils.isNonNativeAcidTable(AlterMaterializedViewRebuildAnalyzer.this.mvTable);
            MaterializedViewRewritingRelVisitor visitor = new MaterializedViewRewritingRelVisitor(acidView);
            visitor.go(basePlan);
            switch (visitor.getIncrementalRebuildMode()) {
                case INSERT_ONLY: {
                    if (materialization.isSourceTablesUpdateDeleteModified()) {
                        return calcitePreMVRewritingPlan;
                    }
                    if (visitor.isContainsAggregate()) {
                        return this.applyAggregateInsertIncremental(basePlan, mdProvider, executorProvider, optCluster, materialization, calcitePreMVRewritingPlan);
                    }
                    return this.applyJoinInsertIncremental(basePlan, mdProvider, executorProvider);
                }
                case AVAILABLE: {
                    if (!materialization.isSourceTablesUpdateDeleteModified()) {
                        return this.applyAggregateInsertIncremental(basePlan, mdProvider, executorProvider, optCluster, materialization, calcitePreMVRewritingPlan);
                    }
                    return this.applyAggregateInsertDeleteIncremental(basePlan, mdProvider, executorProvider);
                }
            }
            if (materialization.isSourceTablesUpdateDeleteModified()) {
                return calcitePreMVRewritingPlan;
            }
            return this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
        }

        private RelNode applyAggregateInsertDeleteIncremental(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.AGGREGATE_INSERT_DELETE_REBUILD;
            return this.applyIncrementalRebuild(basePlan, mdProvider, executorProvider, HiveAggregateInsertDeleteIncrementalRewritingRule.INSTANCE);
        }

        private RelNode applyAggregateInsertIncremental(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider, RelOptCluster optCluster, HiveRelOptMaterialization materialization, RelNode calcitePreMVRewritingPlan) {
            AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.AGGREGATE_INSERT_REBUILD;
            RelNode incrementalRebuildPlan = this.applyIncrementalRebuild(basePlan, mdProvider, executorProvider, HiveInsertOnlyScanWriteIdRule.INSTANCE, HiveAggregateInsertIncrementalRewritingRule.INSTANCE);
            RelOptCost costOriginalPlan = this.calculateCost(optCluster, mdProvider, HiveTezModelRelMetadataProvider.DEFAULT, calcitePreMVRewritingPlan);
            RelOptCost costIncrementalRebuildPlan = this.calculateCost(optCluster, mdProvider, HiveIncrementalRelMdRowCount.createMetadataProvider(materialization), incrementalRebuildPlan);
            double factorSelectivity = HiveConf.getFloatVar((Configuration)AlterMaterializedViewRebuildAnalyzer.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL_FACTOR);
            costIncrementalRebuildPlan = costIncrementalRebuildPlan.multiplyBy(factorSelectivity);
            if (costOriginalPlan.isLe(costIncrementalRebuildPlan)) {
                AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD;
                return calcitePreMVRewritingPlan;
            }
            return incrementalRebuildPlan;
        }

        private RelNode applyJoinInsertIncremental(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.JOIN_INSERT_REBUILD;
            return this.applyIncrementalRebuild(basePlan, mdProvider, executorProvider, HiveInsertOnlyScanWriteIdRule.INSTANCE, HiveJoinInsertIncrementalRewritingRule.INSTANCE);
        }

        private RelNode applyPartitionIncrementalRebuildPlan(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider, HiveRelOptMaterialization materialization, RelOptCluster optCluster, RelNode calcitePreMVRewritingPlan) {
            if (materialization.isSourceTablesUpdateDeleteModified()) {
                return calcitePreMVRewritingPlan;
            }
            RelOptHiveTable hiveTable = (RelOptHiveTable)materialization.tableRel.getTable();
            if (!AcidUtils.isInsertOnlyTable(hiveTable.getHiveTableMD())) {
                return this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
            }
            RelNode incrementalRebuildPlan = this.applyIncrementalRebuild(basePlan, mdProvider, executorProvider, HiveInsertOnlyScanWriteIdRule.INSTANCE, HiveAggregatePartitionIncrementalRewritingRule.INSTANCE);
            RelOptCost costOriginalPlan = this.calculateCost(optCluster, mdProvider, HiveTezModelRelMetadataProvider.DEFAULT, calcitePreMVRewritingPlan);
            RelOptCost costIncrementalRebuildPlan = this.calculateCost(optCluster, mdProvider, HiveIncrementalRelMdRowCount.createMetadataProvider(materialization), incrementalRebuildPlan);
            double factorSelectivity = HiveConf.getFloatVar((Configuration)AlterMaterializedViewRebuildAnalyzer.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL_FACTOR);
            if (costOriginalPlan.isLe(costIncrementalRebuildPlan = costIncrementalRebuildPlan.multiplyBy(factorSelectivity))) {
                AlterMaterializedViewRebuildAnalyzer.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD;
                return calcitePreMVRewritingPlan;
            }
            return incrementalRebuildPlan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RelOptCost calculateCost(RelOptCluster optCluster, RelMetadataProvider originalMetadataProvider, JaninoRelMetadataProvider metadataProvider, RelNode plan) {
            optCluster.invalidateMetadataQuery();
            RelMetadataQuery.THREAD_PROVIDERS.set(metadataProvider);
            try {
                RelOptCost relOptCost = RelMetadataQuery.instance().getCumulativeCost(plan);
                return relOptCost;
            }
            finally {
                optCluster.invalidateMetadataQuery();
                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)originalMetadataProvider));
            }
        }

        private RelNode applyIncrementalRebuild(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider, RelOptRule ... rebuildRules) {
            HepProgramBuilder program = new HepProgramBuilder();
            this.generatePartialProgram(program, false, HepMatchOrder.DEPTH_FIRST, rebuildRules);
            basePlan = this.executeProgram(basePlan, program.build(), mdProvider, executorProvider);
            return this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
        }
    }
}

