/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;

public class TableScanOperator
extends Operator<TableScanDesc>
implements Serializable,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private VectorizationContext taskVectorizationContext;
    protected JobConf jc;
    private boolean inputFileChanged = false;
    private TableDesc tableDesc;
    private Stat currentStat;
    private Map<String, Stat> stats;
    private int rowLimit = -1;
    private int currCount = 0;
    private boolean insideView;
    private boolean vectorized;
    private String defaultPartitionName;
    private String schemaEvolutionColumns;
    private String schemaEvolutionColumnsTypes;
    private ProbeDecodeContext probeDecodeContextSet;

    public TableDesc getTableDescSkewJoin() {
        return this.tableDesc;
    }

    public void setTableDescSkewJoin(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    public void setSchemaEvolution(String schemaEvolutionColumns, String schemaEvolutionColumnsTypes) {
        this.schemaEvolutionColumns = schemaEvolutionColumns;
        this.schemaEvolutionColumnsTypes = schemaEvolutionColumnsTypes;
    }

    public String getSchemaEvolutionColumns() {
        return this.schemaEvolutionColumns;
    }

    public String getSchemaEvolutionColumnsTypes() {
        return this.schemaEvolutionColumnsTypes;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (this.rowLimit >= 0 && this.checkSetDone(row, tag)) {
            return;
        }
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats()) {
            this.gatherStats(row);
        }
        if (this.vectorized) {
            this.vectorForward((VectorizedRowBatch)row);
        } else {
            this.forward(row, this.inputObjInspectors[tag]);
        }
    }

    private boolean checkSetDone(Object row, int tag) {
        if (row instanceof VectorizedRowBatch) {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            if (this.currCount >= this.rowLimit) {
                this.setDone(true);
                return true;
            }
            if (this.currCount + batch.size > this.rowLimit) {
                batch.size = this.rowLimit - this.currCount;
            }
            this.currCount += batch.size;
        } else if (this.currCount++ >= this.rowLimit) {
            this.setDone(true);
            return true;
        }
        return false;
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
        this.updateFileId();
    }

    private void updateFileId() {
        Map<String, Integer> bucketNameMapping;
        Map<String, Integer> map = bucketNameMapping = this.conf != null ? ((TableScanDesc)this.conf).getBucketFileNameMapping() : null;
        if (bucketNameMapping != null && !bucketNameMapping.isEmpty()) {
            Path currentInputPath = this.getExecContext().getCurrentInputPath();
            this.getExecContext().setFileId(Integer.toString(bucketNameMapping.get(currentInputPath.getName())));
        }
    }

    private void gatherStats(Object row) {
        if (this.currentStat == null || this.inputFileChanged) {
            String partitionSpecs;
            this.inputFileChanged = false;
            if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
                partitionSpecs = "";
            } else {
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                ArrayList writable = new ArrayList(((TableScanDesc)this.conf).getPartColumns().size());
                ArrayList<String> values = new ArrayList<String>(((TableScanDesc)this.conf).getPartColumns().size());
                int dpStartCol = 0;
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
                for (StructField sf : soi.getAllStructFieldRefs()) {
                    String fn = sf.getFieldName();
                    if (((TableScanDesc)this.conf).getPartColumns().contains(fn)) break;
                    ++dpStartCol;
                }
                ObjectInspectorUtils.partialCopyToStandardObject(writable, (Object)row, (int)dpStartCol, (int)((TableScanDesc)this.conf).getPartColumns().size(), (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (Object o : writable) {
                    values.add(o == null ? this.defaultPartitionName : o.toString());
                }
                partitionSpecs = FileUtils.makePartName(((TableScanDesc)this.conf).getPartColumns(), values);
                this.LOG.info("Stats Gathering found a new partition spec = " + partitionSpecs);
            }
            int uSizeColumn = -1;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            for (int i = 0; i < soi.getAllStructFieldRefs().size(); ++i) {
                if (!((StructField)soi.getAllStructFieldRefs().get(i)).getFieldName().equals(VirtualColumn.RAWDATASIZE.getName().toLowerCase())) continue;
                uSizeColumn = i;
                break;
            }
            this.currentStat = this.stats.get(partitionSpecs);
            if (this.currentStat == null) {
                this.currentStat = new Stat();
                this.currentStat.setBookkeepingInfo("rawDataSize", uSizeColumn);
                this.stats.put(partitionSpecs, this.currentStat);
            }
        }
        this.currentStat.addToStat("numRows", 1L);
        int rdSizeColumn = this.currentStat.getBookkeepingInfo("rawDataSize");
        if (rdSizeColumn != -1) {
            ArrayList rdSize = new ArrayList(1);
            ObjectInspectorUtils.partialCopyToStandardObject(rdSize, (Object)row, (int)rdSizeColumn, (int)1, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.currentStat.addToStat("rawDataSize", ((LongWritable)rdSize.get(0)).get());
        }
    }

    protected TableScanOperator() {
    }

    public TableScanOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.inputFileChanged = false;
        if (this.conf == null) {
            return;
        }
        this.rowLimit = ((TableScanDesc)this.conf).getRowLimit();
        this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf);
        this.defaultPartitionName = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
        this.currentStat = null;
        this.stats = new HashMap<String, Stat>();
        this.vectorized = ((TableScanDesc)this.conf).isVectorized();
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.getExecContext() != null && this.getExecContext().getFileId() == null) {
            this.updateFileId();
        }
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats() && this.stats.size() != 0) {
            this.publishStats();
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return TableScanOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "TS";
    }

    public void setNeededColumnIDs(List<Integer> orign_columns) {
        ((TableScanDesc)this.conf).setNeededColumnIDs(orign_columns);
    }

    public List<Integer> getNeededColumnIDs() {
        return ((TableScanDesc)this.conf).getNeededColumnIDs();
    }

    public void setNeededColumns(List<String> columnNames) {
        ((TableScanDesc)this.conf).setNeededColumns(columnNames);
    }

    public List<String> getNeededNestedColumnPaths() {
        return ((TableScanDesc)this.conf).getNeededNestedColumnPaths();
    }

    public void setNeededNestedColumnPaths(List<String> nestedColumnPaths) {
        ((TableScanDesc)this.conf).setNeededNestedColumnPaths(nestedColumnPaths);
    }

    public List<String> getNeededColumns() {
        return ((TableScanDesc)this.conf).getNeededColumns();
    }

    public void setReferencedColumns(List<String> referencedColumns) {
        ((TableScanDesc)this.conf).setReferencedColumns(referencedColumns);
    }

    public List<String> getReferencedColumns() {
        return ((TableScanDesc)this.conf).getReferencedColumns();
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TABLESCAN;
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((TableScanDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        StatsCollectionContext sc = new StatsCollectionContext((Configuration)this.jc);
        sc.setStatsTmpDir(((TableScanDesc)this.conf).getTmpStatsDir());
        sc.setContextSuffix(this.getOperatorId());
        if (!statsPublisher.connect(sc)) {
            this.LOG.info("StatsPublishing error: cannot connect to database.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        HashMap<String, String> statsToPublish = new HashMap<String, String>();
        for (String pspecs : this.stats.keySet()) {
            statsToPublish.clear();
            String prefix = Utilities.join(((TableScanDesc)this.conf).getStatsAggPrefix(), pspecs);
            Object key = prefix.endsWith("/") ? prefix : prefix + "/";
            for (String statType : this.stats.get(pspecs).getStoredStats()) {
                statsToPublish.put(statType, Long.toString(this.stats.get(pspecs).getStat(statType)));
            }
            if (!statsPublisher.publishStat((String)key, statsToPublish) && isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
            }
            this.LOG.info("publishing : " + (String)key + " : " + statsToPublish);
        }
        if (!statsPublisher.closeConnection(sc) && isStatsReliable) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public Operator<? extends OperatorDesc> clone() throws CloneNotSupportedException {
        TableScanOperator ts = (TableScanOperator)super.clone();
        ts.setNeededColumnIDs(new ArrayList<Integer>(this.getNeededColumnIDs()));
        ts.setNeededColumns(new ArrayList<String>(this.getNeededColumns()));
        ts.setReferencedColumns(new ArrayList<String>(this.getReferencedColumns()));
        return ts;
    }

    public boolean isInsideView() {
        return this.insideView;
    }

    public void setInsideView(boolean insiderView) {
        this.insideView = insiderView;
    }

    public void setTaskVectorizationContext(VectorizationContext taskVectorizationContext) {
        this.taskVectorizationContext = taskVectorizationContext;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.taskVectorizationContext;
    }

    public ProbeDecodeContext getProbeDecodeContext() {
        return this.probeDecodeContextSet;
    }

    public void setProbeDecodeContext(ProbeDecodeContext probeDecodeContext) {
        this.probeDecodeContextSet = probeDecodeContext;
    }

    public TableName getTableName() {
        Table tableMetadata = ((TableScanDesc)this.conf).getTableMetadata();
        return TableName.fromString((String)tableMetadata.getTableName(), (String)tableMetadata.getCatName(), (String)tableMetadata.getDbName());
    }

    public static class ProbeDecodeContext {
        private final String mjSmallTableCacheKey;
        private final String mjBigTableKeyColName;
        private final byte mjSmallTablePos;
        private final double keyRatio;

        public ProbeDecodeContext(String mjSmallTableCacheKey, byte mjSmallTablePos, String mjBigTableKeyColName, double keyRatio) {
            this.mjSmallTableCacheKey = mjSmallTableCacheKey;
            this.mjSmallTablePos = mjSmallTablePos;
            this.mjBigTableKeyColName = mjBigTableKeyColName;
            this.keyRatio = keyRatio;
        }

        public String getMjSmallTableCacheKey() {
            return this.mjSmallTableCacheKey;
        }

        public byte getMjSmallTablePos() {
            return this.mjSmallTablePos;
        }

        public String getMjBigTableKeyColName() {
            return this.mjBigTableKeyColName;
        }

        public double getKeyRatio() {
            return this.keyRatio;
        }

        public String toString() {
            return "cacheKey:" + this.mjSmallTableCacheKey + ", bigKeyColName:" + this.mjBigTableKeyColName + ", smallTablePos:" + this.mjSmallTablePos + ", keyRatio:" + this.keyRatio;
        }
    }
}

