/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.collect.Collections2;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.owner.AlterDatabaseSetOwnerDesc;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateViewDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.AckWork;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.OptimisedBootstrapUtils;
import org.apache.hadoop.hive.ql.exec.repl.PreAckTask;
import org.apache.hadoop.hive.ql.exec.repl.RangerDenyWork;
import org.apache.hadoop.hive.ql.exec.repl.RangerLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.PartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadConstraint;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadDatabase;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadPartitions;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadTable;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadTasksBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.log.IncrementalLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.thrift.TException;

public class ReplLoadTask
extends Task<ReplLoadWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ZERO_TASKS = 0;
    private final String STAGE_NAME = "REPL_LOAD";
    private List<TxnType> excludedTxns = Arrays.asList(TxnType.READ_ONLY, TxnType.REPL_CREATED);

    public String getName() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? "REPL_INCREMENTAL_LOAD" : "REPL_BOOTSTRAP_LOAD";
    }

    @Override
    public StageType getType() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? StageType.REPL_INCREMENTAL_LOAD : StageType.REPL_BOOTSTRAP_LOAD;
    }

    @Override
    public int execute() {
        try {
            long loadTaskStartTime = System.currentTimeMillis();
            SecurityUtils.reloginExpiringKeytabUser();
            if (MetaStoreUtils.isDbReplIncompatible((Database)this.getHive().getDatabase(((ReplLoadWork)this.work).getTargetDatabase()))) {
                throw new SemanticException(ErrorMsg.REPL_INCOMPATIBLE_EXCEPTION, new String[]{((ReplLoadWork)this.work).dbNameToLoadIn});
            }
            Task<?> rootTask = ((ReplLoadWork)this.work).getRootTask();
            if (rootTask != null) {
                rootTask.setChildTasks(null);
            }
            ((ReplLoadWork)this.work).setRootTask(this);
            this.parentTasks = null;
            String mapRedCustomName = ReplUtils.getDistCpCustomName(this.conf, ((ReplLoadWork)this.work).dbNameToLoadIn);
            this.conf.set("mapreduce.job.name", mapRedCustomName);
            if (this.shouldLoadAtlasMetadata()) {
                this.addAtlasLoadTask();
            }
            if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_RANGER_HANDLE_DENY_POLICY_TARGET)) {
                this.initiateRangerDenyTask();
            }
            if (this.shouldLoadAuthorizationMetadata()) {
                this.initiateAuthorizationLoadTask();
            }
            LOG.info("Data copy at load enabled : {}", (Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET));
            if (((ReplLoadWork)this.work).isIncrementalLoad()) {
                return this.executeIncrementalLoad(loadTaskStartTime);
            }
            return this.executeBootStrapLoad();
        }
        catch (RuntimeException e) {
            LOG.error("replication failed with run time exception", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, new Path(((ReplLoadWork)this.work).getDumpDirectory()).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector(), "REPL_LOAD", this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, new Path(((ReplLoadWork)this.work).getDumpDirectory()).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector(), "REPL_LOAD", this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    private boolean shouldLoadAuthorizationMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_AUTHORIZATION_METADATA);
    }

    private void initiateRangerDenyTask() throws SemanticException {
        RangerDenyWork rangerDenyWork;
        if ("ranger".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE))) {
            LOG.info("Adding Ranger Deny Policy Task for {} ", (Object)((ReplLoadWork)this.work).dbNameToLoadIn);
            rangerDenyWork = new RangerDenyWork(new Path(((ReplLoadWork)this.work).getDumpDirectory()), ((ReplLoadWork)this.work).getSourceDbName(), ((ReplLoadWork)this.work).dbNameToLoadIn, ((ReplLoadWork)this.work).getMetricCollector());
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
        } else {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Authorizer: " + this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE) + " not supported for deny policy creation. Currently Only supports: ", "ranger"}));
        }
        this.childTasks.add(TaskFactory.get(rangerDenyWork, this.conf));
    }

    private void initiateAuthorizationLoadTask() throws SemanticException {
        Task<RangerLoadWork> rangerLoadTask;
        if ("ranger".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE))) {
            Path rangerLoadRoot = new Path(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), "ranger");
            LOG.info("Adding Import Ranger Metadata Task from {} ", (Object)rangerLoadRoot);
            String targetDbName = StringUtils.isEmpty((CharSequence)((ReplLoadWork)this.work).dbNameToLoadIn) ? ((ReplLoadWork)this.work).getSourceDbName() : ((ReplLoadWork)this.work).dbNameToLoadIn;
            RangerLoadWork rangerLoadWork = new RangerLoadWork(rangerLoadRoot, ((ReplLoadWork)this.work).getSourceDbName(), targetDbName, ((ReplLoadWork)this.work).getMetricCollector());
            rangerLoadTask = TaskFactory.get(rangerLoadWork, this.conf);
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
        } else {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Authorizer " + this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE) + " not supported for replication ", "ranger"}));
        }
        this.childTasks.add(rangerLoadTask);
    }

    private void addAtlasLoadTask() throws HiveException {
        Path atlasDumpDir = new Path(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), "atlas");
        LOG.info("Adding task to load Atlas metadata from {} ", (Object)atlasDumpDir);
        String targetDbName = StringUtils.isEmpty((CharSequence)((ReplLoadWork)this.work).dbNameToLoadIn) ? ((ReplLoadWork)this.work).getSourceDbName() : ((ReplLoadWork)this.work).dbNameToLoadIn;
        AtlasLoadWork atlasLoadWork = new AtlasLoadWork(((ReplLoadWork)this.work).getSourceDbName(), targetDbName, atlasDumpDir, ((ReplLoadWork)this.work).getMetricCollector());
        Task<AtlasLoadWork> atlasLoadTask = TaskFactory.get(atlasLoadWork, this.conf);
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.add(atlasLoadTask);
    }

    private boolean shouldLoadAtlasMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_ATLAS_METADATA);
    }

    private int executeBootStrapLoad() throws Exception {
        boolean addAnotherLoadTask;
        int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
        Context loadContext = new Context(((ReplLoadWork)this.work).dumpDirectory, this.conf, this.getHive(), ((ReplLoadWork)this.work).sessionStateLineageState, this.context);
        TaskTracker loadTaskTracker = new TaskTracker(maxTasks);
        BootstrapEventsIterator iterator = ((ReplLoadWork)this.work).bootstrapIterator();
        this.addLazyDataCopyTask(loadTaskTracker, iterator.replLogger());
        ConstraintEventsIterator constraintIterator = ((ReplLoadWork)this.work).constraintsIterator();
        TaskTracker dbTracker = new TaskTracker(0);
        TaskTracker tableTracker = new TaskTracker(0);
        Scope scope = new Scope();
        boolean loadingConstraint = false;
        if (!iterator.hasNext() && constraintIterator.hasNext()) {
            loadingConstraint = true;
        }
        boolean dbEventFound = false;
        while ((iterator.hasNext() || loadingConstraint && constraintIterator.hasNext()) && loadTaskTracker.canAddMoreTasks()) {
            BootstrapEvent next = !loadingConstraint ? iterator.next() : constraintIterator.next();
            switch (next.eventType()) {
                case Database: {
                    DatabaseEvent dbEvent = (DatabaseEvent)next;
                    dbTracker = new LoadDatabase(loadContext, dbEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, loadTaskTracker, ((ReplLoadWork)this.work).getMetricCollector()).tasks();
                    loadTaskTracker.update(dbTracker);
                    if (((ReplLoadWork)this.work).hasDbState()) {
                        loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
                    } else {
                        scope.database = false;
                    }
                    ((ReplLoadWork)this.work).updateDbEventState(dbEvent.toState());
                    if (dbTracker.hasTasks()) {
                        scope.rootTasks.addAll(dbTracker.tasks());
                        scope.database = true;
                        dbEventFound = true;
                    }
                    dbTracker.debugLog("database");
                    break;
                }
                case Table: {
                    TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
                    FSTableEvent tableEvent = (FSTableEvent)next;
                    if (TableType.VIRTUAL_VIEW.name().equals(tableEvent.getMetaData().getTable().getTableType())) {
                        tableTracker = new TaskTracker(1);
                        tableTracker.addTask(ReplLoadTask.createViewTask(tableEvent.getMetaData(), ((ReplLoadWork)this.work).dbNameToLoadIn, this.conf, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector()));
                    } else {
                        LoadTable loadTable = new LoadTable(tableEvent, loadContext, iterator.replLogger(), tableContext, loadTaskTracker, ((ReplLoadWork)this.work).getMetricCollector());
                        tableTracker = loadTable.tasks(((ReplLoadWork)this.work).isIncrementalLoad(), ((ReplLoadWork)this.work).isSecondFailover);
                    }
                    this.setUpDependencies(dbTracker, tableTracker);
                    if (!scope.database && tableTracker.hasTasks()) {
                        scope.rootTasks.addAll(tableTracker.tasks());
                        scope.table = true;
                    } else {
                        scope.table = false;
                    }
                    if (TableType.VIRTUAL_VIEW.name().equals(tableEvent.getMetaData().getTable().getTableType())) break;
                    LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), loadTaskTracker, tableEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, tableContext, ((ReplLoadWork)this.work).getMetricCollector(), ((ReplLoadWork)this.work).tablesToBootstrap);
                    TaskTracker partitionsTracker = loadPartitions.tasks();
                    this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                    tableTracker.debugLog("table");
                    partitionsTracker.debugLog("partitions for table");
                    break;
                }
                case Partition: {
                    this.addLoadPartitionTasks(loadContext, next, dbTracker, iterator, scope, loadTaskTracker, tableTracker);
                    break;
                }
                case Function: {
                    loadTaskTracker.update(this.addLoadFunctionTasks(loadContext, iterator, next, dbTracker, scope));
                    break;
                }
                case Constraint: {
                    loadTaskTracker.update(this.addLoadConstraintsTasks(loadContext, next, dbTracker, scope));
                    break;
                }
            }
            if (!loadingConstraint && !iterator.currentDbHasNext()) {
                this.createEndReplLogTask(loadContext, scope, iterator.replLogger());
            }
            if (!dbEventFound || !this.conf.getBoolVar(HiveConf.ConfVars.REPL_RETAIN_CUSTOM_LOCATIONS_FOR_DB_ON_TARGET)) continue;
            LOG.info("Database event found, will be processed exclusively");
            break;
        }
        boolean bl = addAnotherLoadTask = iterator.hasNext() || loadTaskTracker.hasReplicationState() || constraintIterator.hasNext();
        if (addAnotherLoadTask) {
            this.createBuilderTask(scope.rootTasks);
        }
        if (!(iterator.hasNext() || constraintIterator.hasNext() || ((ReplLoadWork)this.work).isIncrementalLoad())) {
            loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
            ((ReplLoadWork)this.work).updateDbEventState(null);
        }
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.addAll(scope.rootTasks);
        LOG.info("Root Tasks / Total Tasks : {} / {} ", (Object)this.childTasks.size(), (Object)loadTaskTracker.numberOfTasks());
        this.context.getFsScratchDirs().putAll(loadContext.pathInfo.getFsScratchDirs());
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY)) {
            this.createReplLoadCompleteAckTask();
        }
        LOG.info("completed load task run : {}", (Object)((ReplLoadWork)this.work).executedLoadTask());
        if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_SNAPSHOT_DIFF_FOR_EXTERNAL_TABLE_COPY)) {
            Path snapPath = SnapshotUtils.getSnapshotFileListPath(new Path(((ReplLoadWork)this.work).dumpDirectory));
            try {
                SnapshotUtils.getDFS(snapPath, this.conf).rename(new Path(snapPath, "_file_list_external_current"), new Path(snapPath, "_file_list_external_old"), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (this.isReadOnlyHookRegistered()) {
            LOG.info("Setting database {} read-only", (Object)((ReplLoadWork)this.work).dbNameToLoadIn);
            this.setDbReadOnly();
        }
        return 0;
    }

    private boolean isReadOnlyHookRegistered() {
        return this.conf.get(HiveConf.ConfVars.PRE_EXEC_HOOKS.varname) != null && this.conf.get(HiveConf.ConfVars.PRE_EXEC_HOOKS.varname).contains("org.apache.hadoop.hive.ql.hooks.EnforceReadOnlyDatabaseHook");
    }

    private void setDbReadOnly() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("readonly", Boolean.TRUE.toString());
        AlterDatabaseSetPropertiesDesc setTargetReadOnly = new AlterDatabaseSetPropertiesDesc(((ReplLoadWork)this.work).dbNameToLoadIn, props, null);
        DDLWork alterDbPropWork = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), setTargetReadOnly, true, ((ReplLoadWork)this.work).dumpDirectory, ((ReplLoadWork)this.work).getMetricCollector());
        Task<DDLWork> addReadOnlyTargetPropTask = TaskFactory.get(alterDbPropWork, this.conf);
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.add(addReadOnlyTargetPropTask);
    }

    private void addLazyDataCopyTask(TaskTracker loadTaskTracker, ReplLogger replLogger) throws IOException {
        boolean dataCopyAtLoad = this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        if (dataCopyAtLoad) {
            if (((ReplLoadWork)this.work).getExternalTableDataCopyItr() == null) {
                Path extTableBackingFile = new Path(((ReplLoadWork)this.work).dumpDirectory, "_file_list_external");
                try (FileList fileList = new FileList(extTableBackingFile, this.conf);){
                    ((ReplLoadWork)this.work).setExternalTableDataCopyItr(fileList);
                }
            }
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
            List<Task<?>> externalTableCopyTasks = ((ReplLoadWork)this.work).externalTableCopyTasks(loadTaskTracker, this.conf);
            LOG.debug("Scheduled {} external table copy tasks", (Object)externalTableCopyTasks.size());
            this.childTasks.addAll(externalTableCopyTasks);
            if (!externalTableCopyTasks.isEmpty() && !((ReplLoadWork)this.work).getExternalTableDataCopyItr().hasNext()) {
                ReplUtils.addLoggerTask(replLogger, this.childTasks, this.conf);
            }
        }
    }

    private TaskTracker addLoadPartitionTasks(Context loadContext, BootstrapEvent next, TaskTracker dbTracker, BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker) throws Exception {
        PartitionEvent event = (PartitionEvent)next;
        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
        LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), tableContext, loadTaskTracker, event.asTableEvent(), ((ReplLoadWork)this.work).dbNameToLoadIn, event.lastPartitionReplicated(), ((ReplLoadWork)this.work).getMetricCollector(), event.lastPartSpecReplicated(), event.lastStageReplicated(), ((ReplLoadWork)this.getWork()).tablesToBootstrap);
        TaskTracker partitionsTracker = loadPartitions.tasks();
        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
        partitionsTracker.debugLog("partitions");
        return partitionsTracker;
    }

    private TaskTracker addLoadConstraintsTasks(Context loadContext, BootstrapEvent next, TaskTracker dbTracker, Scope scope) throws IOException, SemanticException {
        LoadConstraint loadConstraint = new LoadConstraint(loadContext, (ConstraintEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
        TaskTracker constraintTracker = loadConstraint.tasks();
        scope.rootTasks.addAll(constraintTracker.tasks());
        constraintTracker.debugLog("constraints");
        return constraintTracker;
    }

    private TaskTracker addLoadFunctionTasks(Context loadContext, BootstrapEventsIterator iterator, BootstrapEvent next, TaskTracker dbTracker, Scope scope) throws IOException, SemanticException {
        LoadFunction loadFunction = new LoadFunction(loadContext, iterator.replLogger(), (FunctionEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
        TaskTracker functionsTracker = loadFunction.tasks();
        if (!scope.database) {
            scope.rootTasks.addAll(functionsTracker.tasks());
        } else {
            this.setUpDependencies(dbTracker, functionsTracker);
        }
        functionsTracker.debugLog("functions");
        return functionsTracker;
    }

    public static Task<?> createViewTask(MetaData metaData, String dbNameToLoadIn, HiveConf conf, String dumpDirectory, ReplicationMetricCollector metricCollector) throws SemanticException {
        Table table = new Table(metaData.getTable());
        String dbName = dbNameToLoadIn == null ? table.getDbName() : dbNameToLoadIn;
        TableName tableName = HiveTableName.ofNullable(table.getTableName(), dbName);
        String dbDotView = tableName.getNotEmptyDbTable();
        String viewOriginalText = table.getViewOriginalText();
        String viewExpandedText = table.getViewExpandedText();
        if (!dbName.equals(table.getDbName())) {
            // empty if block
        }
        CreateViewDesc desc = new CreateViewDesc(dbDotView, table.getCols(), null, table.getParameters(), table.getPartColNames(), false, false, viewOriginalText, viewExpandedText, table.getPartCols());
        desc.setReplicationSpec(metaData.getReplicationSpec());
        desc.setOwnerName(table.getOwner());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), desc, true, dumpDirectory, metricCollector), conf);
    }

    private void dropTablesExcludedInReplScope(ReplScope replScope) throws HiveException {
        if (replScope == null || replScope.includeAllTables()) {
            return;
        }
        Hive db = this.getHive();
        String dbName = replScope.getDbName();
        Collection tableNames = Collections2.filter(db.getAllTables(dbName), tableName -> {
            assert (tableName != null);
            return !tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase()) && !replScope.tableIncludedInReplScope(tableName);
        });
        for (String table : tableNames) {
            db.dropTable(dbName + "." + table, true);
        }
        LOG.info("Tables in the Database: {} that are excluded in the replication scope are dropped.", (Object)dbName);
    }

    private void createReplLoadCompleteAckTask() {
        if (!(((ReplLoadWork)this.work).hasBootstrapLoadTasks() || ((ReplLoadWork)this.work).isIncrementalLoad() && ((ReplLoadWork)this.work).incrementalLoadTasksBuilder().hasMoreWork())) {
            LinkedList<PreAckTask> listOfPreAckTasks = new LinkedList<PreAckTask>();
            listOfPreAckTasks.add(new PreAckTask(){

                @Override
                public void run() throws SemanticException {
                    try {
                        IMetaStoreClient client = ReplLoadTask.this.getHive().getMSC();
                        long currentNotificationID = client.getCurrentNotificationEventId().getEventId();
                        Path loadMetadataFilePath = new Path(((ReplLoadWork)((ReplLoadTask)ReplLoadTask.this).work).dumpDirectory, ReplAck.LOAD_METADATA.toString());
                        Utils.writeOutput(String.valueOf(currentNotificationID), loadMetadataFilePath, ReplLoadTask.this.conf);
                        LOG.info("Created LOAD Metadata file : {} with NotificationID : {}", (Object)loadMetadataFilePath, (Object)currentNotificationID);
                    }
                    catch (TException ex) {
                        throw new SemanticException((Throwable)ex);
                    }
                }
            });
            if (((ReplLoadWork)this.work).shouldFailover()) {
                listOfPreAckTasks.add(new PreAckTask(){

                    @Override
                    public void run() throws SemanticException {
                        try {
                            Database db = ReplLoadTask.this.getHive().getDatabase(((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase());
                            if (MetaStoreUtils.isDbBeingPlannedFailedOverAtEndpoint((Database)db, (MetaStoreUtils.FailoverEndpoint)MetaStoreUtils.FailoverEndpoint.TARGET)) {
                                return;
                            }
                            HashMap<String, String> params = new HashMap<String, String>(db.getParameters());
                            LOG.info("Setting failover endpoint:{} to TARGET for database: {}", (Object)"repl.failover.endpoint", (Object)db.getName());
                            params.put("repl.failover.endpoint", MetaStoreUtils.FailoverEndpoint.TARGET.toString());
                            LOG.info("Setting {} for database: {}", (Object)"repl.background.enable", (Object)db.getName());
                            params.put("repl.background.enable", "true");
                            params.put("repl.metrics.last.failover.type", ReplConst.FailoverType.PLANNED.toString());
                            LOG.info("Replication Metrics: Setting last failover type for database: {} to: {} ", (Object)db.getName(), (Object)ReplConst.FailoverType.PLANNED.toString());
                            int failoverCount = 1 + NumberUtils.toInt((String)params.getOrDefault("repl.metrics.failover.count", "0"), (int)0);
                            LOG.info("Replication Metrics: Setting replication metrics failover count for database: {} to: {} ", (Object)db.getName(), (Object)failoverCount);
                            params.put("repl.metrics.failover.count", Integer.toString(failoverCount));
                            db.setParameters(params);
                            ReplLoadTask.this.getHive().alterDatabase(((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase(), db);
                        }
                        catch (HiveException e) {
                            throw new SemanticException((Throwable)e);
                        }
                    }
                });
            }
            if (((ReplLoadWork)this.work).isSecondFailover) {
                listOfPreAckTasks.add(new PreAckTask(){

                    @Override
                    public void run() throws SemanticException {
                        try {
                            Hive hiveDb = ReplLoadTask.this.getHive();
                            Database db = hiveDb.getDatabase(((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase());
                            HashMap<String, String> params = new HashMap<String, String>(db.getParameters());
                            LOG.debug("Database {} properties before removal {}", (Object)((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase(), params);
                            params.remove("repl.resume.started");
                            params.remove("repl.source.for");
                            if (!((ReplLoadWork)ReplLoadTask.this.work).shouldFailover()) {
                                params.remove("repl.failover.endpoint");
                            }
                            LOG.info("Removed {} property from database {} after successful optimised bootstrap load.", (Object)"repl.source.for", (Object)((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase());
                            int failbackCount = 1 + NumberUtils.toInt((String)params.getOrDefault("repl.metrics.failback.count", "0"), (int)0);
                            LOG.info("Replication Metrics: Setting replication metrics failback count for database: {} to: {} ", (Object)db.getName(), (Object)failbackCount);
                            params.put("repl.metrics.failback.count", Integer.toString(failbackCount));
                            long failbackEndTime = System.currentTimeMillis();
                            params.put("repl.metrics.last.failback.endtime", Long.toString(failbackEndTime));
                            LOG.info("Replication Metrics: Setting replication metrics failback end time for database: {} to: {} ", (Object)db.getName(), (Object)failbackEndTime);
                            db.setParameters(params);
                            hiveDb.alterDatabase(((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase(), db);
                            LOG.debug("Database {} properties after removal {}", (Object)((ReplLoadWork)ReplLoadTask.this.work).getTargetDatabase(), params);
                        }
                        catch (HiveException e) {
                            throw new SemanticException((Throwable)e);
                        }
                    }
                });
            }
            AckWork replLoadAckWork = new AckWork(new Path(((ReplLoadWork)this.work).dumpDirectory, ReplAck.LOAD_ACKNOWLEDGEMENT.toString()), ((ReplLoadWork)this.work).getMetricCollector(), listOfPreAckTasks);
            Task<AckWork> loadAckWorkTask = TaskFactory.get(replLoadAckWork, this.conf);
            if (this.childTasks.isEmpty()) {
                this.childTasks.add(loadAckWorkTask);
            } else {
                DAGTraversal.traverse(this.childTasks, new AddDependencyToLeaves(Collections.singletonList(loadAckWorkTask)));
            }
        }
    }

    private void createEndReplLogTask(Context context, Scope scope, ReplLogger replLogger) throws SemanticException {
        HashMap<String, String> dbProps;
        if (((ReplLoadWork)this.work).isIncrementalLoad()) {
            dbProps = new HashMap<String, String>();
            dbProps.put(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString(), ((ReplLoadWork)this.work).incrementalLoadTasksBuilder().eventTo().toString());
        } else {
            Database dbInMetadata = ((ReplLoadWork)this.work).databaseEvent(context.hiveConf).dbInMetadata(((ReplLoadWork)this.work).dbNameToLoadIn);
            dbProps = dbInMetadata.getParameters();
        }
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, dbProps, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector(), ((ReplLoadWork)this.work).shouldFailover());
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork, this.conf);
        if (scope.rootTasks.isEmpty()) {
            scope.rootTasks.add(replLogTask);
        } else {
            DAGTraversal.traverse(scope.rootTasks, new AddDependencyToLeaves(Collections.singletonList(replLogTask)));
        }
    }

    private TaskTracker updateDatabaseLastReplID(int maxTasks, Context context, Scope scope) throws SemanticException {
        TaskTracker taskTracker = new LoadDatabase.AlterDatabase(context, ((ReplLoadWork)this.work).databaseEvent(context.hiveConf), ((ReplLoadWork)this.work).dbNameToLoadIn, new TaskTracker(maxTasks), ((ReplLoadWork)this.work).getMetricCollector()).tasks();
        AddDependencyToLeaves function = new AddDependencyToLeaves(taskTracker.tasks());
        DAGTraversal.traverse(scope.rootTasks, function);
        return taskTracker;
    }

    private void partitionsPostProcessing(BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker, TaskTracker partitionsTracker) {
        this.setUpDependencies(tableTracker, partitionsTracker);
        if (!scope.database && !scope.table) {
            scope.rootTasks.addAll(partitionsTracker.tasks());
        }
        loadTaskTracker.update(tableTracker);
        loadTaskTracker.update(partitionsTracker);
        if (partitionsTracker.hasReplicationState()) {
            iterator.setReplicationState(partitionsTracker.replicationState());
        }
    }

    private void setUpDependencies(TaskTracker parentTasks, TaskTracker childTasks) {
        if (parentTasks.hasTasks()) {
            for (Task<?> parentTask : parentTasks.tasks()) {
                for (Task<?> childTask : childTasks.tasks()) {
                    parentTask.addDependentTask(childTask);
                }
            }
        } else {
            for (Task<?> childTask : childTasks.tasks()) {
                parentTasks.addTask(childTask);
            }
        }
    }

    private void createBuilderTask(List<Task<?>> rootTasks) {
        Task<ReplLoadWork> loadTask = TaskFactory.get((ReplLoadWork)this.work, this.conf);
        DAGTraversal.traverse(rootTasks, new AddDependencyToLeaves(loadTask));
    }

    private int executeIncrementalLoad(long loadStartTime) throws Exception {
        IncrementalLoadTasksBuilder builder;
        if (((ReplLoadWork)this.work).replScopeModified) {
            this.dropTablesExcludedInReplScope(((ReplLoadWork)this.work).currentReplScope);
        }
        Database targetDb = this.getHive().getDatabase(((ReplLoadWork)this.work).dbNameToLoadIn);
        HashMap<String, String> props = new HashMap<String, String>();
        if (!this.isDbReadOnly(targetDb) && this.isReadOnlyHookRegistered()) {
            this.setDbReadOnly();
        }
        if (((ReplLoadWork)this.work).isFirstFailover) {
            if (MetaStoreUtils.isTargetOfReplication((Database)targetDb)) {
                LOG.error("The database {} is already marked as target for replication", (Object)targetDb.getName());
                throw new Exception("Failover target is already marked as target");
            }
            if (!ReplChangeManager.isSourceOfReplication((Database)targetDb)) {
                LOG.error("The database {} is already source of replication.", (Object)targetDb.getName());
                throw new Exception("Failover target was not source of replication");
            }
            HashMap<String, String> params = targetDb.getParameters();
            if (params == null) {
                params = new HashMap<String, String>();
            }
            long failbackStartTime = System.currentTimeMillis();
            params.put("repl.metrics.last.failback.starttime", Long.toString(failbackStartTime));
            LOG.info("Replication Metrics: Setting replication metrics failback starttime for database: {} to: {} ", (Object)targetDb.getName(), (Object)failbackStartTime);
            if (!MetaStoreUtils.isDbBeingPlannedFailedOver((Database)targetDb)) {
                LOG.info("Replication Metrics: Setting last failover type for database: {} to: {} ", (Object)targetDb.getName(), (Object)ReplConst.FailoverType.UNPLANNED.toString());
                params.put("repl.metrics.last.failover.type", ReplConst.FailoverType.UNPLANNED.toString());
                int failoverCount = 1 + NumberUtils.toInt((String)params.getOrDefault("repl.metrics.failover.count", "0"), (int)0);
                LOG.info("Replication Metrics: Setting replication metrics failover count for database: {} to: {} ", (Object)targetDb.getName(), (Object)failoverCount);
                params.put("repl.metrics.failover.count", Integer.toString(failoverCount));
            }
            ((ReplLoadWork)this.work).getMetricCollector().reportStageStart("REPL_LOAD", new HashMap<String, Long>());
            boolean isTableDiffPresent = OptimisedBootstrapUtils.checkFileExists(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), this.conf, "table_diff_complete");
            boolean isAbortTxnsListPresent = OptimisedBootstrapUtils.checkFileExists(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), this.conf, "abort_txns");
            Long l = Long.parseLong(OptimisedBootstrapUtils.getEventIdFromFile(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), this.conf)[0]);
            List<NotificationEvent> notificationEvents = OptimisedBootstrapUtils.getListOfNotificationEvents(l, this.getHive(), (ReplLoadWork)this.work);
            if (!isAbortTxnsListPresent) {
                HiveTxnManager hiveTxnManager = this.getTxnMgr();
                ValidTxnList validTxnList = hiveTxnManager.getValidTxns(this.excludedTxns);
                HashSet<Long> allOpenTxns = new HashSet<Long>(ReplUtils.getOpenTxns(validTxnList));
                this.abortOpenTxnsForDatabase(hiveTxnManager, validTxnList, ((ReplLoadWork)this.work).dbNameToLoadIn, this.getHive());
                notificationEvents = OptimisedBootstrapUtils.getListOfNotificationEvents(l, this.getHive(), (ReplLoadWork)this.work);
                OptimisedBootstrapUtils.prepareAbortTxnsFile(notificationEvents, allOpenTxns, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), this.conf);
            }
            if (!isTableDiffPresent) {
                OptimisedBootstrapUtils.prepareTableDiffFile(notificationEvents, this.getHive(), (ReplLoadWork)this.work, this.conf);
            }
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
            this.createReplLoadCompleteAckTask();
            ((ReplLoadWork)this.work).getMetricCollector().reportStageEnd("REPL_LOAD", Status.SUCCESS);
            if (Boolean.parseBoolean((String)targetDb.getParameters().get("repl.resume.started"))) {
                ((ReplLoadWork)this.work).getMetricCollector().reportEnd(Status.RESUME_READY);
            } else {
                ((ReplLoadWork)this.work).getMetricCollector().reportEnd(Status.SUCCESS);
            }
            targetDb.setParameters(params);
            this.getHive().alterDatabase(((ReplLoadWork)this.work).dbNameToLoadIn, targetDb);
            return 0;
        }
        if (((ReplLoadWork)this.work).isSecondFailover) {
            Hive db = this.getHive();
            for (String table : ((ReplLoadWork)this.work).tablesToDrop) {
                LOG.info("Dropping table {} for optimised bootstrap", (Object)(((ReplLoadWork)this.work).dbNameToLoadIn + "." + table));
                db.dropTable(((ReplLoadWork)this.work).dbNameToLoadIn + "." + table, true);
            }
            Database sourceDb = this.getSourceDbMetadata();
            Map sourceDbProps = sourceDb.getParameters();
            HashMap targetDbProps = new HashMap(targetDb.getParameters());
            for (String string : MetaStoreUtils.getReplicationDbProps()) {
                targetDbProps.remove(string);
            }
            for (Map.Entry entry : targetDbProps.entrySet()) {
                String actualVal = (String)sourceDbProps.get(entry.getKey());
                if (((String)entry.getValue()).equals(actualVal)) continue;
                props.put((String)entry.getKey(), actualVal == null ? "" : actualVal);
            }
            AlterDatabaseSetOwnerDesc alterDbDesc = new AlterDatabaseSetOwnerDesc(sourceDb.getName(), new PrincipalDesc(sourceDb.getOwnerName(), sourceDb.getOwnerType()), null);
            DDLWork dDLWork = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc, true, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
            this.childTasks.add(TaskFactory.get(dDLWork, this.conf));
        }
        if (!MetaStoreUtils.isTargetOfReplication((Database)targetDb)) {
            props.put("repl.target.for", "true");
        }
        if (!((ReplLoadWork)this.work).shouldFailover() && MetaStoreUtils.isDbBeingPlannedFailedOver((Database)targetDb)) {
            props.put("repl.failover.endpoint", "");
        }
        if (!props.isEmpty()) {
            AlterDatabaseSetPropertiesDesc setTargetDesc = new AlterDatabaseSetPropertiesDesc(((ReplLoadWork)this.work).dbNameToLoadIn, props, null);
            Task<DDLWork> addReplTargetPropTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), setTargetDesc, true, ((ReplLoadWork)this.work).dumpDirectory, ((ReplLoadWork)this.work).getMetricCollector()), this.conf);
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
            this.childTasks.add(addReplTargetPropTask);
        }
        if (!(builder = ((ReplLoadWork)this.work).incrementalLoadTasksBuilder()).hasMoreWork() && ((ReplLoadWork)this.work).isLastReplIDUpdated() && ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
            LOG.debug("Current incremental dump have tables to be bootstrapped. Switching to bootstrap mode after applying all events.");
            return this.executeBootStrapLoad();
        }
        ArrayList childTasks = new ArrayList();
        int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
        TaskTracker tracker = new TaskTracker(maxTasks);
        this.addLazyDataCopyTask(tracker, builder.getReplLogger());
        childTasks.add(builder.build(this.context, this.getHive(), LOG, tracker));
        if (!builder.hasMoreWork()) {
            String string;
            String dbName = ((ReplLoadWork)this.work).dbNameToLoadIn;
            if ((dbName == null || StringUtils.isBlank((CharSequence)dbName)) && ((ReplLoadWork)this.work).currentReplScope != null && (string = ((ReplLoadWork)this.work).currentReplScope.getDbName()) != null && !"*".equals(string)) {
                dbName = string;
            }
            if (StringUtils.isNotBlank((CharSequence)dbName)) {
                String string2 = builder.eventTo().toString();
                HashMap<String, String> mapProp = new HashMap<String, String>();
                mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString(), string2);
                AlterDatabaseSetPropertiesDesc alterDbDesc = new AlterDatabaseSetPropertiesDesc(dbName, mapProp, new ReplicationSpec(string2, string2));
                Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc, true, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector()), this.conf);
                DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(updateReplIdTask));
                ((ReplLoadWork)this.work).setLastReplIDUpdated(true);
                LOG.debug("Added task to set last repl id of db " + dbName + " to " + string2);
            }
        }
        if (builder.hasMoreWork() || ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
            DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(TaskFactory.get((ReplLoadWork)this.work, this.conf)));
        }
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.addAll(childTasks);
        this.createReplLoadCompleteAckTask();
        if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_SNAPSHOT_DIFF_FOR_EXTERNAL_TABLE_COPY)) {
            SnapshotUtils.cleanupSnapshots(new Path(((ReplLoadWork)this.work).getDumpDirectory()).getParent().getParent().getParent(), ((ReplLoadWork)this.work).getSourceDbName().toLowerCase(), this.conf, null, true);
        }
        long currentTimestamp = System.currentTimeMillis();
        ((IncrementalLoadLogger)((ReplLoadWork)this.work).incrementalLoadTasksBuilder().getReplLogger()).initiateEventTimestamp(currentTimestamp);
        LOG.info("REPL_INCREMENTAL_LOAD stage duration : {} ms", (Object)(currentTimestamp - loadStartTime));
        return 0;
    }

    private boolean isDbReadOnly(Database db) {
        Map dbParameters = db.getParameters();
        return dbParameters != null && Boolean.parseBoolean((String)dbParameters.get("readonly"));
    }

    private void abortOpenTxnsForDatabase(HiveTxnManager hiveTxnManager, ValidTxnList validTxnList, String dbName, Hive hiveDb) throws HiveException {
        List<Long> openTxns = ReplUtils.getOpenTxns(hiveTxnManager, validTxnList, dbName);
        if (!openTxns.isEmpty()) {
            LOG.info("Rolling back write txns:" + openTxns.toString() + " for the database: " + dbName);
            hiveDb.abortTransactions(openTxns, TxnErrorMsg.ABORT_ONGOING_TXN_FOR_TARGET_DB.getErrorCode());
            validTxnList = hiveTxnManager.getValidTxns(this.excludedTxns);
            openTxns = ReplUtils.getOpenTxns(hiveTxnManager, validTxnList, dbName);
            if (!openTxns.isEmpty()) {
                LOG.warn("Unable to force abort all the open txns: {}.", openTxns);
                throw new IllegalStateException("Failover triggered abort txns request failed for unknown reasons.");
            }
        }
    }

    private Database getSourceDbMetadata() throws IOException, SemanticException {
        Path dbMetadata = new Path(((ReplLoadWork)this.work).dumpDirectory, "metadata");
        BootstrapEventsIterator itr = new BootstrapEventsIterator(dbMetadata.toString(), ((ReplLoadWork)this.work).dbNameToLoadIn, true, this.conf, ((ReplLoadWork)this.work).getMetricCollector());
        if (!itr.hasNext()) {
            throw new SemanticException("Unable to find source db metadata in " + dbMetadata.toString());
        }
        BootstrapEvent next = itr.next();
        if (!next.eventType().equals((Object)BootstrapEvent.EventType.Database)) {
            throw new SemanticException("Invalid eventType: " + next.eventType() + " encountered while fetching source db metadata from " + dbMetadata.toString());
        }
        return ((DatabaseEvent)next).dbInMetadata(((ReplLoadWork)this.work).dbNameToLoadIn);
    }

    private static class Scope {
        boolean database = false;
        boolean table = false;
        List<Task<?>> rootTasks = new ArrayList();

        private Scope() {
        }
    }
}

