/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.incremental;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.misc.flags.ReplRemoveFirstIncLoadPendFlagDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.FailoverMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.parse.repl.load.log.IncrementalLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.slf4j.Logger;

public class IncrementalLoadTasksBuilder {
    private final String dbName;
    private final IncrementalLoadEventsIterator iterator;
    private final HashSet<ReadEntity> inputs;
    private final HashSet<WriteEntity> outputs;
    private Logger log;
    private final HiveConf conf;
    private final ReplLogger replLogger;
    private static long numIteration;
    private final Long eventTo;
    private String dumpDirectory;
    private final ReplicationMetricCollector metricCollector;
    private boolean shouldFailover;

    public ReplLogger getReplLogger() {
        return this.replLogger;
    }

    public IncrementalLoadTasksBuilder(String dbName, String loadPath, IncrementalLoadEventsIterator iterator, HiveConf conf, Long eventTo, ReplicationMetricCollector metricCollector, ReplStatsTracker replStatsTracker, boolean shouldFailover, int bootstrapTableSize) throws SemanticException {
        this.dbName = dbName;
        this.dumpDirectory = new Path(loadPath).getParent().toString();
        this.iterator = iterator;
        this.inputs = new HashSet();
        this.outputs = new HashSet();
        this.log = null;
        this.conf = conf;
        this.replLogger = new IncrementalLoadLogger(dbName, loadPath, iterator.getTotalEventsCount(), replStatsTracker);
        this.replLogger.startLog();
        this.eventTo = eventTo;
        IncrementalLoadTasksBuilder.setNumIteration(0);
        this.metricCollector = metricCollector;
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.EVENTS.name(), Long.valueOf(iterator.getTotalEventsCount()));
        this.shouldFailover = shouldFailover;
        if (shouldFailover) {
            Map params;
            Database db = null;
            try {
                db = Hive.get().getDatabase(dbName);
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
            String dbFailoverEndPoint = "";
            if (db != null && (params = db.getParameters()) != null) {
                dbFailoverEndPoint = (String)params.get("repl.failover.endpoint");
            }
            this.metricCollector.reportFailoverStart("REPL_LOAD", metricMap, new FailoverMetaData(new Path(this.dumpDirectory, "hive"), conf), dbFailoverEndPoint, ReplConst.FailoverType.PLANNED.toString());
        } else {
            if (bootstrapTableSize > 0) {
                metricMap.put(ReplUtils.MetricName.TABLES.name(), Long.valueOf(bootstrapTableSize));
            }
            this.metricCollector.reportStageStart("REPL_LOAD", metricMap);
        }
    }

    public Task<?> build(Context context, Hive hive, Logger log, TaskTracker tracker) throws Exception {
        long builderStartTime = System.currentTimeMillis();
        Task<DependencyCollectionWork> evTaskRoot = TaskFactory.get(new DependencyCollectionWork());
        Task<Serializable> taskChainTail = evTaskRoot;
        Long lastReplayedEvent = null;
        this.log = log;
        this.log.debug("Iteration num " + ++numIteration);
        while (this.iterator.hasNext() && tracker.canAddMoreTasks()) {
            String location;
            DumpMetaData eventDmd;
            FileStatus dir = this.iterator.next();
            if (!this.shouldReplayEvent(dir, (eventDmd = new DumpMetaData(new Path(location = dir.getPath().toUri().toString()), this.conf)).getDumpType(), this.dbName)) {
                this.log.debug("Skipping event {} from {} for DB {} maxTasks: {}", new Object[]{eventDmd.getDumpType(), dir.getPath().toUri(), this.dbName, tracker.numberOfTasks()});
                continue;
            }
            this.log.debug("Loading event {} from {} for DB {} maxTasks: {}", new Object[]{eventDmd.getDumpType(), dir.getPath().toUri(), this.dbName, tracker.numberOfTasks()});
            MessageHandler.Context mhContext = new MessageHandler.Context(this.dbName, location, taskChainTail, eventDmd, this.conf, hive, context, this.log, this.dumpDirectory, this.metricCollector);
            List<Task<?>> evTasks = this.analyzeEventLoad(mhContext);
            if (evTasks != null && !evTasks.isEmpty()) {
                ReplStateLogWork replStateLogWork = new ReplStateLogWork(this.replLogger, this.metricCollector, dir.getPath().getName(), eventDmd.getDumpType().toString(), this.dumpDirectory);
                Task<ReplStateLogWork> barrierTask = TaskFactory.get(replStateLogWork, this.conf);
                AddDependencyToLeaves function = new AddDependencyToLeaves(barrierTask);
                DAGTraversal.traverse(evTasks, function);
                this.log.debug("Updated taskChainTail from {}:{} to {}:{}", new Object[]{taskChainTail.getClass(), taskChainTail.getId(), barrierTask.getClass(), barrierTask.getId()});
                tracker.addTaskList(taskChainTail.getChildTasks());
                taskChainTail = barrierTask;
            }
            lastReplayedEvent = eventDmd.getEventTo();
        }
        if (!this.hasMoreWork()) {
            ReplRemoveFirstIncLoadPendFlagDesc desc = new ReplRemoveFirstIncLoadPendFlagDesc(this.dbName);
            Task<DDLWork> updateIncPendTask = TaskFactory.get(new DDLWork(this.inputs, this.outputs, desc, true, this.dumpDirectory, this.metricCollector), this.conf);
            taskChainTail.addDependentTask(updateIncPendTask);
            taskChainTail = updateIncPendTask;
            HashMap<String, String> dbProps = new HashMap<String, String>();
            dbProps.put(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString(), String.valueOf(lastReplayedEvent == null ? this.eventTo : lastReplayedEvent));
            ReplStateLogWork replStateLogWork = new ReplStateLogWork(this.replLogger, dbProps, this.dumpDirectory, this.metricCollector, this.shouldFailover);
            Task<ReplStateLogWork> barrierTask = TaskFactory.get(replStateLogWork, this.conf);
            taskChainTail.addDependentTask(barrierTask);
            this.log.debug("Added {}:{} as a precursor of barrier task {}:{}", new Object[]{taskChainTail.getClass(), taskChainTail.getId(), barrierTask.getClass(), barrierTask.getId()});
        }
        this.log.info("REPL_INCREMENTAL_LOAD task-builder iteration #{}, duration : {} ms", (Object)numIteration, (Object)(System.currentTimeMillis() - builderStartTime));
        return evTaskRoot;
    }

    public boolean hasMoreWork() {
        return this.iterator.hasNext();
    }

    private boolean isEventNotReplayed(Map<String, String> params, FileStatus dir, DumpType dumpType) {
        String replLastId;
        if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString()) && Long.parseLong(replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString())) >= Long.parseLong(dir.getPath().getName())) {
            this.log.debug("Event " + dumpType + " with replId " + Long.parseLong(dir.getPath().getName()) + " is already replayed. LastReplId - " + Long.parseLong(replLastId));
            return false;
        }
        return true;
    }

    private boolean shouldReplayEvent(FileStatus dir, DumpType dumpType, String dbName) {
        if (StringUtils.isBlank((CharSequence)dbName)) {
            return true;
        }
        try {
            Database database = Hive.get().getDatabase(dbName);
            return database == null || this.isEventNotReplayed(database.getParameters(), dir, dumpType);
        }
        catch (HiveException e) {
            this.log.debug("Failed to get the database " + dbName);
            return true;
        }
    }

    private List<Task<?>> analyzeEventLoad(MessageHandler.Context context) throws SemanticException {
        MessageHandler messageHandler = context.dmd.getDumpType().handler();
        List<Task<?>> tasks = messageHandler.handle(context);
        if (context.precursor != null) {
            for (Task<?> t : tasks) {
                context.precursor.addDependentTask(t);
                this.log.debug("Added {}:{} as a precursor of {}:{}", new Object[]{context.precursor.getClass(), context.precursor.getId(), t.getClass(), t.getId()});
            }
        }
        this.inputs.addAll(messageHandler.readEntities());
        this.outputs.addAll(messageHandler.writeEntities());
        return this.addUpdateReplStateTasks(messageHandler.getUpdatedMetadata(), tasks);
    }

    private Task<?> dbUpdateReplStateTask(String dbName, String replState, Task<?> preCursor) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString(), replState);
        AlterDatabaseSetPropertiesDesc alterDbDesc = new AlterDatabaseSetPropertiesDesc(dbName, mapProp, new ReplicationSpec(replState, replState));
        Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork(this.inputs, this.outputs, alterDbDesc, true, this.dumpDirectory, this.metricCollector), this.conf);
        if (preCursor != null) {
            preCursor.addDependentTask(updateReplIdTask);
            this.log.debug("Added {}:{} as a precursor of {}:{}", new Object[]{preCursor.getClass(), preCursor.getId(), updateReplIdTask.getClass(), updateReplIdTask.getId()});
        }
        return updateReplIdTask;
    }

    private List<Task<?>> addUpdateReplStateTasks(UpdatedMetaDataTracker updatedMetaDataTracker, List<Task<?>> importTasks) throws SemanticException {
        if (importTasks.isEmpty()) {
            this.log.debug("No objects need update of repl state: 0 import tasks");
            return importTasks;
        }
        Task<DependencyCollectionWork> barrierTask = TaskFactory.get(new DependencyCollectionWork(), this.conf);
        ArrayList tasks = new ArrayList();
        HashMap<String, Integer> dbS = new HashMap<String, Integer>();
        for (UpdatedMetaDataTracker.UpdateMetaData updateMetaData : updatedMetaDataTracker.getUpdateMetaDataList()) {
            String replState = updateMetaData.getReplState();
            String dbName = updateMetaData.getDbName();
            if (dbS.get(dbName) != null) {
                if (Integer.parseInt(replState) <= (Integer)dbS.get(dbName)) continue;
                dbS.put(dbName, Integer.parseInt(replState));
                continue;
            }
            dbS.put(dbName, Integer.parseInt(replState));
        }
        for (Map.Entry entry : dbS.entrySet()) {
            Task<?> updateReplIdTask = this.dbUpdateReplStateTask(this.dbName, String.valueOf(entry.getValue()), barrierTask);
            tasks.add(updateReplIdTask);
        }
        if (tasks.isEmpty()) {
            this.log.debug("No objects need update of repl state: 0 update tracker tasks");
            return importTasks;
        }
        DAGTraversal.traverse(importTasks, new AddDependencyToLeaves(barrierTask));
        return tasks;
    }

    private static void setNumIteration(int count) {
        numIteration = count;
    }

    public Long eventTo() {
        return this.eventTo;
    }

    public static long getNumIteration() {
        return numIteration;
    }
}

