/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorAggregationDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String aggregationName;
    private TypeInfo inputTypeInfo;
    private ColumnVector.Type inputColVectorType;
    private VectorExpression inputExpression;
    private TypeInfo outputTypeInfo;
    private ColumnVector.Type outputColVectorType;
    private DataTypePhysicalVariation outputDataTypePhysicalVariation;
    private Class<? extends VectorAggregateExpression> vecAggrClass;
    private List<ConstantVectorExpression> constants;
    private GenericUDAFEvaluator evaluator;
    private GenericUDAFEvaluator.Mode udafEvaluatorMode;

    public VectorAggregationDesc() {
    }

    @Deprecated
    public VectorAggregationDesc(String aggregationName, GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode udafEvaluatorMode, TypeInfo inputTypeInfo, ColumnVector.Type inputColVectorType, VectorExpression inputExpression, TypeInfo outputTypeInfo, ColumnVector.Type outputColVectorType, Class<? extends VectorAggregateExpression> vecAggrClass) {
        this.aggregationName = aggregationName;
        this.evaluator = evaluator;
        this.udafEvaluatorMode = udafEvaluatorMode;
        this.inputTypeInfo = inputTypeInfo;
        this.inputColVectorType = inputColVectorType;
        this.inputExpression = inputExpression;
        this.outputTypeInfo = outputTypeInfo;
        this.outputColVectorType = outputColVectorType;
        this.outputDataTypePhysicalVariation = outputColVectorType == ColumnVector.Type.DECIMAL_64 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE;
        this.vecAggrClass = vecAggrClass;
    }

    public String getAggregationName() {
        return this.aggregationName;
    }

    public GenericUDAFEvaluator.Mode getUdafEvaluatorMode() {
        return this.udafEvaluatorMode;
    }

    public TypeInfo getInputTypeInfo() {
        return this.inputTypeInfo;
    }

    public ColumnVector.Type getInputColVectorType() {
        return this.inputColVectorType;
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public TypeInfo getOutputTypeInfo() {
        return this.outputTypeInfo;
    }

    public ColumnVector.Type getOutputColVectorType() {
        return this.outputColVectorType;
    }

    public DataTypePhysicalVariation getOutputDataTypePhysicalVariation() {
        return this.outputDataTypePhysicalVariation;
    }

    public GenericUDAFEvaluator getEvaluator() {
        return this.evaluator;
    }

    public Class<? extends VectorAggregateExpression> getVecAggrClass() {
        return this.vecAggrClass;
    }

    public List<ConstantVectorExpression> getConstants() {
        return this.constants;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vecAggrClass.getSimpleName());
        if (this.inputExpression != null) {
            sb.append("(");
            sb.append(this.inputExpression);
            sb.append(") -> ");
        } else {
            sb.append("(*) -> ");
        }
        sb.append(this.outputTypeInfo.toString());
        if (this.outputDataTypePhysicalVariation != null && this.outputDataTypePhysicalVariation != DataTypePhysicalVariation.NONE) {
            sb.append("/");
            sb.append(this.outputDataTypePhysicalVariation);
        }
        if (GenericUDAFVariance.isVarianceFamilyName(this.aggregationName)) {
            sb.append(" aggregation: ");
            sb.append(this.aggregationName);
        }
        return sb.toString();
    }

    public static class VectorAggregationDescBuilder {
        private String aggregationName;
        private TypeInfo inputTypeInfo;
        private ColumnVector.Type inputColVectorType;
        private VectorExpression inputExpression;
        private TypeInfo outputTypeInfo;
        private ColumnVector.Type outputColVectorType;
        private DataTypePhysicalVariation outputDataTypePhysicalVariation;
        private Class<? extends VectorAggregateExpression> vecAggrClass;
        private List<ConstantVectorExpression> constants;
        private GenericUDAFEvaluator evaluator;
        private GenericUDAFEvaluator.Mode udafEvaluatorMode;

        public VectorAggregationDescBuilder aggregationName(String aggregationName) {
            this.aggregationName = aggregationName;
            return this;
        }

        public VectorAggregationDescBuilder evaluator(GenericUDAFEvaluator evaluator) {
            this.evaluator = evaluator;
            return this;
        }

        public VectorAggregationDescBuilder udafEvaluatorMode(GenericUDAFEvaluator.Mode udafEvaluatorMode) {
            this.udafEvaluatorMode = udafEvaluatorMode;
            return this;
        }

        public VectorAggregationDescBuilder inputTypeInfo(TypeInfo inputTypeInfo) {
            this.inputTypeInfo = inputTypeInfo;
            return this;
        }

        public VectorAggregationDescBuilder inputColVectorType(ColumnVector.Type inputColVectorType) {
            this.inputColVectorType = inputColVectorType;
            return this;
        }

        public VectorAggregationDescBuilder inputExpression(VectorExpression inputExpression) {
            this.inputExpression = inputExpression;
            return this;
        }

        public VectorAggregationDescBuilder outputTypeInfo(TypeInfo outputTypeInfo) {
            this.outputTypeInfo = outputTypeInfo;
            return this;
        }

        public VectorAggregationDescBuilder outputColVectorType(ColumnVector.Type outputColVectorType) {
            this.outputColVectorType = outputColVectorType;
            this.outputDataTypePhysicalVariation = outputColVectorType == ColumnVector.Type.DECIMAL_64 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE;
            return this;
        }

        public VectorAggregationDescBuilder vectorAggregationClass(Class<? extends VectorAggregateExpression> vecAggrClass) {
            this.vecAggrClass = vecAggrClass;
            return this;
        }

        public VectorAggregationDescBuilder constants(List<ConstantVectorExpression> constants) {
            this.constants = constants;
            return this;
        }

        public VectorAggregationDesc build() {
            VectorAggregationDesc vectorAggregationDesc = new VectorAggregationDesc();
            vectorAggregationDesc.aggregationName = this.aggregationName;
            vectorAggregationDesc.evaluator = this.evaluator;
            vectorAggregationDesc.udafEvaluatorMode = this.udafEvaluatorMode;
            vectorAggregationDesc.inputTypeInfo = this.inputTypeInfo;
            vectorAggregationDesc.inputColVectorType = this.inputColVectorType;
            vectorAggregationDesc.inputExpression = this.inputExpression;
            vectorAggregationDesc.outputTypeInfo = this.outputTypeInfo;
            vectorAggregationDesc.outputColVectorType = this.outputColVectorType;
            vectorAggregationDesc.outputDataTypePhysicalVariation = this.outputDataTypePhysicalVariation;
            vectorAggregationDesc.vecAggrClass = this.vecAggrClass;
            vectorAggregationDesc.constants = this.constants;
            return vectorAggregationDesc;
        }
    }
}

