/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.common.util.BloomKFilter;

public class VectorInBloomFilterColDynamicValue
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final DynamicValue bloomFilterDynamicValue;
    protected transient boolean initialized = false;
    protected transient BloomKFilter bloomFilter;
    protected transient BloomFilterCheck bfCheck;
    protected transient ColumnVector.Type colVectorType;
    private ObjectCache runtimeCache;

    public VectorInBloomFilterColDynamicValue(int colNum, DynamicValue bloomFilterDynamicValue) {
        super(colNum, -1);
        this.bloomFilterDynamicValue = bloomFilterDynamicValue;
    }

    public VectorInBloomFilterColDynamicValue() {
        this.bloomFilterDynamicValue = null;
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.colVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(this.inputTypeInfos[0]);
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.bloomFilterDynamicValue.setConf(conf);
        switch (this.colVectorType) {
            case LONG: 
            case DECIMAL_64: {
                this.bfCheck = new LongBloomFilterCheck();
                break;
            }
            case DOUBLE: {
                this.bfCheck = new DoubleBloomFilterCheck();
                break;
            }
            case DECIMAL: {
                this.bfCheck = new DecimalBloomFilterCheck();
                break;
            }
            case BYTES: {
                this.bfCheck = new BytesBloomFilterCheck();
                break;
            }
            case TIMESTAMP: {
                this.bfCheck = new TimestampBloomFilterCheck();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type " + this.colVectorType);
            }
        }
        String queryId = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        this.runtimeCache = ObjectCacheFactory.getCache(conf, queryId, false, true);
    }

    private void initValue() {
        try {
            this.bloomFilter = (BloomKFilter)this.runtimeCache.retrieve(this.bloomFilterDynamicValue.getId(), new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws IOException {
                    NonSyncByteArrayInputStream in;
                    block4: {
                        BloomKFilter bloomKFilter;
                        in = null;
                        Object val = VectorInBloomFilterColDynamicValue.this.bloomFilterDynamicValue.getValue();
                        VectorInBloomFilterColDynamicValue.this.LOG.info("Starting BloomKFilter deserialization for id: {}...", (Object)VectorInBloomFilterColDynamicValue.this.bloomFilterDynamicValue.getId());
                        if (val == null) break block4;
                        BinaryObjectInspector boi = (BinaryObjectInspector)VectorInBloomFilterColDynamicValue.this.bloomFilterDynamicValue.getObjectInspector();
                        byte[] bytes = boi.getPrimitiveJavaObject(val);
                        in = new NonSyncByteArrayInputStream(bytes);
                        BloomKFilter bloomKFilter2 = bloomKFilter = BloomKFilter.deserialize((InputStream)in);
                        IOUtils.closeStream((Closeable)in);
                        return bloomKFilter2;
                    }
                    try {
                        BloomKFilter bloomKFilter = BloomKFilter.build((long)1L);
                        return bloomKFilter;
                    }
                    finally {
                        IOUtils.closeStream(in);
                    }
                }
            });
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (!this.initialized) {
            this.initValue();
        }
        ColumnVector inputColVector = batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.bloomFilter == null || this.bloomFilter.getNumBits() == 0L) {
            batch.size = 0;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.bfCheck.checkValue(inputColVector, 0)) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.bfCheck.checkValue(inputColVector, i)) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.bfCheck.checkValue(inputColVector, i)) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.bfCheck.checkValue(inputColVector, 0)) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.bfCheck.checkValue(inputColVector, i)) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.bfCheck.checkValue(inputColVector, i)) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, VectorExpressionDescriptor.ArgumentType.BINARY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.DYNAMICVALUE);
        return b.build();
    }

    @Override
    public String vectorExpressionParameters() {
        return null;
    }

    class LongBloomFilterCheck
    extends BloomFilterCheck {
        LongBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            LongColumnVector col = (LongColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testLong(col.vector[idx]);
        }
    }

    abstract class BloomFilterCheck {
        BloomFilterCheck() {
        }

        public abstract boolean checkValue(ColumnVector var1, int var2);
    }

    class DoubleBloomFilterCheck
    extends BloomFilterCheck {
        DoubleBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            DoubleColumnVector col = (DoubleColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testDouble(col.vector[idx]);
        }
    }

    class DecimalBloomFilterCheck
    extends BloomFilterCheck {
        private byte[] scratchBuffer = new byte[79];

        DecimalBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            DecimalColumnVector col = (DecimalColumnVector)columnVector;
            int startIdx = col.vector[idx].toBytes(this.scratchBuffer);
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testBytes(this.scratchBuffer, startIdx, this.scratchBuffer.length - startIdx);
        }
    }

    class BytesBloomFilterCheck
    extends BloomFilterCheck {
        BytesBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            BytesColumnVector col = (BytesColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testBytes(col.vector[idx], col.start[idx], col.length[idx]);
        }
    }

    class TimestampBloomFilterCheck
    extends BloomFilterCheck {
        TimestampBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            TimestampColumnVector col = (TimestampColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testLong(col.time[idx]);
        }
    }
}

