/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.WritableComparable;

public class RecordIdentifier
implements WritableComparable<RecordIdentifier> {
    private long writeId;
    private int bucketId;
    private long rowId;

    public RecordIdentifier() {
    }

    public RecordIdentifier(long writeId, int bucket, long rowId) {
        this.writeId = writeId;
        this.bucketId = bucket;
        this.rowId = rowId;
    }

    public void setValues(long writeId, int bucketId, long rowId) {
        this.writeId = writeId;
        this.bucketId = bucketId;
        this.rowId = rowId;
    }

    public void set(RecordIdentifier other) {
        this.writeId = other.writeId;
        this.bucketId = other.bucketId;
        this.rowId = other.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    public long getWriteId() {
        return this.writeId;
    }

    public int getBucketProperty() {
        return this.bucketId;
    }

    public long getRowId() {
        return this.rowId;
    }

    protected int compareToInternal(RecordIdentifier other) {
        if (other == null) {
            return -1;
        }
        if (this.writeId != other.writeId) {
            return this.writeId < other.writeId ? -1 : 1;
        }
        if (this.bucketId != other.bucketId) {
            return this.bucketId < other.bucketId ? -1 : 1;
        }
        if (this.rowId != other.rowId) {
            return this.rowId < other.rowId ? -1 : 1;
        }
        return 0;
    }

    public int compareTo(RecordIdentifier other) {
        if (other.getClass() != RecordIdentifier.class) {
            return -other.compareTo(this);
        }
        return this.compareToInternal(other);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.writeId);
        dataOutput.writeInt(this.bucketId);
        dataOutput.writeLong(this.rowId);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.writeId = dataInput.readLong();
        this.bucketId = dataInput.readInt();
        this.rowId = dataInput.readLong();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        RecordIdentifier oth = (RecordIdentifier)other;
        return oth.writeId == this.writeId && oth.bucketId == this.bucketId && oth.rowId == this.rowId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.writeId ^ this.writeId >>> 32);
        result = 31 * result + this.bucketId;
        result = 31 * result + (int)(this.rowId ^ this.rowId >>> 32);
        return result;
    }

    public String toString() {
        return "RecordIdentifier(" + this.writeId + ", " + RecordIdentifier.bucketToString(this.bucketId) + "," + this.getRowId() + ")";
    }

    public static String bucketToString(int bucketId) {
        if (bucketId == -1) {
            return "" + bucketId;
        }
        BucketCodec codec = BucketCodec.determineVersion(bucketId);
        return bucketId + "(" + codec.getVersion() + "." + codec.decodeWriterId(bucketId) + "." + codec.decodeStatementId(bucketId) + ")";
    }

    public static final class StructInfo {
        private static final List<String> fieldNames = new ArrayList<String>(Field.values().length);
        private static final List<TypeInfo> fieldTypes = new ArrayList<TypeInfo>(fieldNames.size());
        private static final List<ObjectInspector> fieldOis = new ArrayList<ObjectInspector>(fieldNames.size());
        public static final TypeInfo typeInfo;
        public static final ObjectInspector oi;

        public static void toArray(RecordIdentifier ri, Object[] struct) {
            assert (struct != null && struct.length == Field.values().length);
            if (ri == null) {
                Arrays.fill(struct, null);
                return;
            }
            struct[Field.writeId.ordinal()] = ri.getWriteId();
            struct[Field.bucketId.ordinal()] = ri.getBucketProperty();
            struct[Field.rowId.ordinal()] = ri.getRowId();
        }

        static {
            for (Field f : Field.values()) {
                fieldNames.add(f.name());
                fieldTypes.add(f.fieldType);
                fieldOis.add(f.fieldOI);
            }
            typeInfo = TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypes);
            oi = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOis);
        }
    }

    public static enum Field {
        writeId((TypeInfo)TypeInfoFactory.longTypeInfo, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector),
        bucketId((TypeInfo)TypeInfoFactory.intTypeInfo, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector),
        rowId((TypeInfo)TypeInfoFactory.longTypeInfo, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);

        public final TypeInfo fieldType;
        public final ObjectInspector fieldOI;

        private Field(TypeInfo fieldType, ObjectInspector fieldOI) {
            this.fieldType = fieldType;
            this.fieldOI = fieldOI;
        }
    }
}

