/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.GetDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsSpecByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreClientWithLocalCache
extends HiveMetaStoreClient
implements IMetaStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientWithLocalCache.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static Cache<CacheKey, Object> mscLocalCache = null;
    private static long maxSize;
    private static boolean recordStats;
    private static HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimator;
    private static String cacheObjName;

    public static synchronized void init(Configuration conf) {
        if (!INITIALIZED.get()) {
            LOG.info("Initializing local cache in HiveMetaStoreClient...");
            maxSize = HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_MAX_SIZE);
            recordStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_RECORD_STATS);
            HiveMetaStoreClientWithLocalCache.initSizeEstimator();
            HiveMetaStoreClientWithLocalCache.initCache();
            LOG.info("Local cache initialized in HiveMetaStoreClient: {}", mscLocalCache);
            INITIALIZED.set(true);
        }
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        super(conf, hookLoader, allowEmbedded);
    }

    private static void initSizeEstimator() {
        sizeEstimator = new HashMap();
        IncrementalObjectSizeEstimator.createEstimators(CacheKey.class, sizeEstimator);
        for (KeyType e : KeyType.values()) {
            for (Class<?> c : e.keyClasses) {
                IncrementalObjectSizeEstimator.createEstimators(c, sizeEstimator);
            }
            IncrementalObjectSizeEstimator.createEstimators(e.valueClass, sizeEstimator);
        }
    }

    private static int getWeight(CacheKey key, Object val) {
        IncrementalObjectSizeEstimator.ObjectEstimator keySizeEstimator = sizeEstimator.get(key.getClass());
        IncrementalObjectSizeEstimator.ObjectEstimator valSizeEstimator = sizeEstimator.get(key.IDENTIFIER.valueClass);
        int keySize = keySizeEstimator.estimate((Object)key, sizeEstimator);
        int valSize = valSizeEstimator.estimate(val, sizeEstimator);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache entry weight - key: {}, value: {}, total: {}", new Object[]{keySize, valSize, keySize + valSize});
        }
        return keySize + valSize;
    }

    private static void initCache() {
        int initSize = 100;
        Caffeine cacheBuilder = Caffeine.newBuilder().initialCapacity(initSize).maximumWeight(maxSize).weigher(HiveMetaStoreClientWithLocalCache::getWeight).removalListener((key, val, cause) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caffeine - ({}, {}) was removed ({})", new Object[]{key, val, cause});
            }
        });
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        mscLocalCache = cacheBuilder.build();
        cacheObjName = cacheBuilder.toString();
    }

    protected GetTableResult getTableInternal(GetTableRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), req.getId())).isValid()) {
            CacheKey cacheKey = new CacheKey(KeyType.TABLE, req);
            GetTableResult r = (GetTableResult)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getTableInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getTableInternal, dbName={}, tblName={}, columnStats={}", new Object[]{req.getDbName(), req.getTblName(), req.isGetColumnStats()});
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getTableInternal(req);
    }

    protected PartitionsByExprResult getPartitionsByExprInternal(PartitionsByExprRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_BY_EXPR, watermark, req);
            PartitionsByExprResult r = (PartitionsByExprResult)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getPartitionsByExprInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getPartitionsByExprInternal(req);
    }

    protected List<String> listPartitionNamesInternal(String catName, String dbName, String tableName, int maxParts) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(dbName, tableName), this.getTable(dbName, tableName).getId())).isValid()) {
            CacheKey cacheKey = new CacheKey(KeyType.LIST_PARTITIONS_ALL, watermark, catName, dbName, tableName, maxParts);
            PartitionNamesWrapper r = (PartitionNamesWrapper)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = new PartitionNamesWrapper(super.listPartitionNamesInternal(catName, dbName, tableName, maxParts));
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=listPartitionNamesInternal, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r.partitionNames;
        }
        return super.listPartitionNamesInternal(catName, dbName, tableName, maxParts);
    }

    protected PartitionsSpecByExprResult getPartitionsSpecByExprInternal(PartitionsByExprRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDbName(), req.getTblName()), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_SPEC_BY_EXPR, watermark, req);
            PartitionsSpecByExprResult r = (PartitionsSpecByExprResult)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getPartitionsSpecByExprInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsSpecByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getPartitionsSpecByExprInternal(req);
    }

    protected TableStatsResult getTableColumnStatisticsInternal(TableStatsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDbName(), req.getTblName()), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            CacheWrapper cache = new CacheWrapper(mscLocalCache);
            Pair<List<ColumnStatisticsObj>, List<String>> p = this.getTableColumnStatisticsCache(cache, req, watermark);
            List colStatsMissing = (List)p.getRight();
            List colStats = (List)p.getLeft();
            if (colStatsMissing.isEmpty()) {
                return new TableStatsResult(colStats);
            }
            TableStatsRequest newRqst = new TableStatsRequest(req);
            newRqst.setColNames(colStatsMissing);
            TableStatsResult r = super.getTableColumnStatisticsInternal(newRqst);
            List<ColumnStatisticsObj> newColStats = this.loadTableColumnStatisticsCache(cache, r, req, watermark);
            TableStatsResult result = this.computeTableColumnStatisticsFinal(req, colStats, newColStats);
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return result;
        }
        return super.getTableColumnStatisticsInternal(req);
    }

    protected AggrStats getAggrStatsForInternal(PartitionsStatsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            CacheKey cacheKey = new CacheKey(KeyType.AGGR_COL_STATS, watermark, req);
            AggrStats r = (AggrStats)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getAggrStatsForInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getAggrStatsForInternal, dbName={}, tblName={}, partNames={}", new Object[]{req.getDbName(), req.getTblName(), req.getPartNames()});
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getAggrStatsForInternal(req);
    }

    protected GetPartitionsByNamesResult getPartitionsByNamesInternal(GetPartitionsByNamesRequest rqst) throws TException {
        if (this.isCacheEnabledAndInitialized()) {
            String dbName = MetaStoreUtils.parseDbName((String)rqst.getDb_name(), (Configuration)this.conf)[1];
            TableWatermark watermark = new TableWatermark(rqst.getValidWriteIdList(), this.getTable(dbName, rqst.getTbl_name()).getId());
            if (watermark.isValid()) {
                CacheWrapper cache = new CacheWrapper(mscLocalCache);
                Pair<List<Partition>, List<String>> p = this.getPartitionsByNamesCache(cache, rqst, watermark);
                List partitionsMissing = (List)p.getRight();
                List partitions = (List)p.getLeft();
                if (partitionsMissing.isEmpty()) {
                    return new GetPartitionsByNamesResult(partitions);
                }
                GetPartitionsByNamesRequest newRqst = new GetPartitionsByNamesRequest(rqst);
                newRqst.setNames(partitionsMissing);
                GetPartitionsByNamesResult r = super.getPartitionsByNamesInternal(newRqst);
                List<Partition> newPartitions = this.loadPartitionsByNamesCache(cache, r, rqst, watermark);
                GetPartitionsByNamesResult result = this.computePartitionsByNamesFinal(rqst, partitions, newPartitions);
                if (LOG.isDebugEnabled() && recordStats) {
                    LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
                }
                return result;
            }
        }
        return super.getPartitionsByNamesInternal(rqst);
    }

    private boolean isCacheEnabledAndInitialized() {
        SessionState sessionState = SessionState.get();
        if (sessionState == null || sessionState.getQueryCache(this.getQueryId()) == null) {
            return false;
        }
        return INITIALIZED.get();
    }

    protected String getQueryId() {
        try {
            return Hive.get().getConf().get(HiveConf.ConfVars.HIVE_QUERY_ID.varname);
        }
        catch (HiveException e) {
            LOG.error("Error getting query id. Query level and Global HMS caching will be disabled", (Throwable)e);
            return null;
        }
    }

    protected final Pair<List<ColumnStatisticsObj>, List<String>> getTableColumnStatisticsCache(CacheI cache, TableStatsRequest rqst, TableWatermark watermark) {
        ArrayList<String> colStatsMissing = new ArrayList<String>();
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
        for (String colName : rqst.getColNames()) {
            CacheKey cacheKey = new CacheKey(KeyType.TABLE_COLUMN_STATS, watermark, rqst.getDbName(), rqst.getTblName(), colName, rqst.getCatName(), rqst.getValidWriteIdList(), rqst.getEngine(), rqst.getId());
            ColumnStatisticsObj v = (ColumnStatisticsObj)cache.get(cacheKey);
            if (v == null) {
                colStatsMissing.add(colName);
                continue;
            }
            if (watermark == null) {
                LOG.debug("Query level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, colName={}", new Object[]{rqst.getDbName(), rqst.getTblName(), colName});
            } else {
                LOG.debug("HS2 level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, colName={}", new Object[]{rqst.getDbName(), rqst.getTblName(), colName});
            }
            colStats.add(v);
        }
        return Pair.of(colStats, colStatsMissing);
    }

    protected final List<ColumnStatisticsObj> loadTableColumnStatisticsCache(CacheI cache, TableStatsResult r, TableStatsRequest rqst, TableWatermark watermark) {
        ArrayList<ColumnStatisticsObj> newColStats = new ArrayList<ColumnStatisticsObj>();
        for (ColumnStatisticsObj colStat : r.getTableStats()) {
            CacheKey cacheKey = new CacheKey(KeyType.TABLE_COLUMN_STATS, watermark, rqst.getDbName(), rqst.getTblName(), colStat.getColName(), rqst.getCatName(), rqst.getValidWriteIdList(), rqst.getEngine(), rqst.getId());
            cache.put(cacheKey, colStat);
            newColStats.add(colStat);
        }
        return newColStats;
    }

    protected final TableStatsResult computeTableColumnStatisticsFinal(TableStatsRequest rqst, List<ColumnStatisticsObj> colStats, List<ColumnStatisticsObj> newColStats) {
        ArrayList<ColumnStatisticsObj> result = new ArrayList<ColumnStatisticsObj>();
        int i = 0;
        int j = 0;
        for (String colName : rqst.getColNames()) {
            if (i >= colStats.size() || j >= newColStats.size()) break;
            if (colStats.get(i).getColName().equals(colName)) {
                result.add(colStats.get(i));
                ++i;
                continue;
            }
            if (!newColStats.get(j).getColName().equals(colName)) continue;
            result.add(newColStats.get(j));
            ++j;
        }
        while (i < colStats.size()) {
            result.add(colStats.get(i));
            ++i;
        }
        while (j < newColStats.size()) {
            result.add(newColStats.get(j));
            ++j;
        }
        return new TableStatsResult(result);
    }

    protected final Pair<List<Partition>, List<String>> getPartitionsByNamesCache(CacheI cache, GetPartitionsByNamesRequest rqst, TableWatermark watermark) throws MetaException {
        ArrayList<String> partitionsMissing = new ArrayList<String>();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partitionName : rqst.getNames()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_BY_NAMES, watermark, rqst.getDb_name(), rqst.getTbl_name(), Warehouse.getPartValuesFromPartName((String)partitionName), rqst.isGet_col_stats(), rqst.getProcessorCapabilities(), rqst.getProcessorIdentifier(), rqst.getEngine(), rqst.getValidWriteIdList());
            Partition v = (Partition)cache.get(cacheKey);
            if (v == null) {
                partitionsMissing.add(partitionName);
                continue;
            }
            if (watermark == null) {
                LOG.debug("Query level HMS cache: method=getPartitionsByNamesInternal, dbName={}, tblName={}, partitionName={}", new Object[]{rqst.getDb_name(), rqst.getTbl_name(), partitionName});
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsByNamesInternal, dbName={}, tblName={}, partitionName={}", new Object[]{rqst.getDb_name(), rqst.getTbl_name(), partitionName});
            }
            partitions.add(v);
        }
        return Pair.of(partitions, partitionsMissing);
    }

    protected final List<Partition> loadPartitionsByNamesCache(CacheI cache, GetPartitionsByNamesResult r, GetPartitionsByNamesRequest rqst, TableWatermark watermark) {
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        for (Partition partition : r.getPartitions()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_BY_NAMES, watermark, rqst.getDb_name(), rqst.getTbl_name(), partition.getValues(), rqst.isGet_col_stats(), rqst.getProcessorCapabilities(), rqst.getProcessorIdentifier(), rqst.getEngine(), rqst.getValidWriteIdList());
            cache.put(cacheKey, partition);
            newPartitions.add(partition);
        }
        return newPartitions;
    }

    protected final GetPartitionsByNamesResult computePartitionsByNamesFinal(GetPartitionsByNamesRequest rqst, List<Partition> partitions, List<Partition> newPartitions) throws MetaException {
        ArrayList<Partition> result = new ArrayList<Partition>();
        int i = 0;
        int j = 0;
        for (String partitionName : rqst.getNames()) {
            if (i >= partitions.size() || j >= newPartitions.size()) break;
            List pv = Warehouse.getPartValuesFromPartName((String)partitionName);
            if (partitions.get(i).getValues().equals(pv)) {
                result.add(partitions.get(i));
                ++i;
                continue;
            }
            if (!newPartitions.get(j).getValues().equals(pv)) continue;
            result.add(newPartitions.get(j));
            ++j;
        }
        while (i < partitions.size()) {
            result.add(partitions.get(i));
            ++i;
        }
        while (j < newPartitions.size()) {
            result.add(newPartitions.get(j));
            ++j;
        }
        return new GetPartitionsByNamesResult(result);
    }

    protected final Pair<List<TableValidWriteIds>, List<String>> getValidWriteIdsCache(CacheI cache, GetValidWriteIdsRequest rqst) {
        ArrayList<String> fullTableNamesMissing = new ArrayList<String>();
        ArrayList<TableValidWriteIds> tblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (String fullTableName : rqst.getFullTableNames()) {
            CacheKey cacheKey = new CacheKey(KeyType.VALID_WRITE_IDS, fullTableName, rqst.getValidTxnList(), rqst.getWriteId());
            TableValidWriteIds v = (TableValidWriteIds)cache.get(cacheKey);
            if (v == null) {
                fullTableNamesMissing.add(fullTableName);
                continue;
            }
            LOG.debug("Query level HMS cache: method=getValidWriteIdsInternal, fullTableName={}", (Object)fullTableName);
            tblValidWriteIds.add(v);
        }
        return Pair.of(tblValidWriteIds, fullTableNamesMissing);
    }

    protected final List<TableValidWriteIds> loadValidWriteIdsCache(CacheI cache, GetValidWriteIdsResponse r, GetValidWriteIdsRequest rqst) {
        ArrayList<TableValidWriteIds> newTblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (TableValidWriteIds tableValidWriteIds : r.getTblValidWriteIds()) {
            newTblValidWriteIds.add(tableValidWriteIds);
            CacheKey cacheKey = new CacheKey(KeyType.VALID_WRITE_IDS, tableValidWriteIds.getFullTableName(), rqst.getValidTxnList(), rqst.getWriteId());
            cache.put(cacheKey, tableValidWriteIds);
        }
        return newTblValidWriteIds;
    }

    protected final GetValidWriteIdsResponse computeValidWriteIdsFinal(GetValidWriteIdsRequest rqst, List<TableValidWriteIds> tblValidWriteIds, List<TableValidWriteIds> newTblValidWriteIds) {
        ArrayList<TableValidWriteIds> result = new ArrayList<TableValidWriteIds>();
        int i = 0;
        int j = 0;
        for (String fullTableName : rqst.getFullTableNames()) {
            if (i >= tblValidWriteIds.size() || j >= newTblValidWriteIds.size()) break;
            if (tblValidWriteIds.get(i).getFullTableName().equals(fullTableName)) {
                result.add(tblValidWriteIds.get(i));
                ++i;
                continue;
            }
            if (!newTblValidWriteIds.get(j).getFullTableName().equals(fullTableName)) continue;
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        while (i < tblValidWriteIds.size()) {
            result.add(tblValidWriteIds.get(i));
            ++i;
        }
        while (j < newTblValidWriteIds.size()) {
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        return new GetValidWriteIdsResponse(result);
    }

    static {
        sizeEstimator = null;
        cacheObjName = null;
    }

    public static class CacheKey {
        KeyType IDENTIFIER;
        List<Object> obj;

        public CacheKey(KeyType IDENTIFIER, Object ... objs) {
            this.IDENTIFIER = IDENTIFIER;
            this.obj = Collections.unmodifiableList(Arrays.asList(objs));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.IDENTIFIER == cacheKey.IDENTIFIER && Objects.equals(this.obj, cacheKey.obj);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.IDENTIFIER, this.obj});
        }

        public String toString() {
            return "CacheKey {" + this.IDENTIFIER.name() + " @@ " + this.obj.toString() + "}";
        }
    }

    public static enum KeyType {
        CONFIG_VALUE(String.class, new Class[0]),
        DATABASE(Database.class, GetDatabaseRequest.class),
        TABLE(GetTableResult.class, GetTableRequest.class),
        PRIMARY_KEYS(PrimaryKeysResponse.class, PrimaryKeysRequest.class),
        FOREIGN_KEYS(ForeignKeysResponse.class, ForeignKeysRequest.class),
        UNIQUE_CONSTRAINTS(UniqueConstraintsResponse.class, UniqueConstraintsRequest.class),
        NOT_NULL_CONSTRAINTS(NotNullConstraintsResponse.class, NotNullConstraintsRequest.class),
        TABLE_COLUMN_STATS(ColumnStatisticsObj.class, String.class, Long.TYPE, TableWatermark.class),
        AGGR_COL_STATS(AggrStats.class, PartitionsStatsRequest.class, TableWatermark.class),
        PARTITIONS_BY_EXPR(PartitionsByExprResult.class, PartitionsByExprRequest.class, TableWatermark.class),
        PARTITIONS_SPEC_BY_EXPR(PartitionsSpecByExprResult.class, PartitionsByExprRequest.class, TableWatermark.class),
        LIST_PARTITIONS_ALL(PartitionNamesWrapper.class, String.class, Integer.TYPE, TableWatermark.class),
        LIST_PARTITIONS(String.class, Integer.TYPE),
        LIST_PARTITIONS_REQ(GetPartitionNamesPsResponse.class, GetPartitionNamesPsRequest.class),
        LIST_PARTITIONS_AUTH_INFO_ALL(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO_REQ(GetPartitionsPsWithAuthResponse.class, GetPartitionsPsWithAuthRequest.class),
        PARTITIONS_BY_NAMES(Partition.class, String.class, Boolean.TYPE, TableWatermark.class),
        VALID_WRITE_IDS(TableValidWriteIds.class, String.class, Long.TYPE),
        TABLE_ID(Long.class, String.class);

        private final List<Class<?>> keyClasses;
        private final Class<?> valueClass;

        private KeyType(Class<?> valueClass, Class<?> ... keyClasses) {
            this.keyClasses = Collections.unmodifiableList(Arrays.asList(keyClasses));
            this.valueClass = valueClass;
        }
    }

    protected static class TableWatermark {
        final String validWriteIdList;
        final long tableId;

        protected TableWatermark(String validWriteIdList, long tableId) {
            this.validWriteIdList = validWriteIdList;
            this.tableId = tableId;
        }

        public boolean isValid() {
            return this.validWriteIdList != null && this.tableId != -1L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableWatermark that = (TableWatermark)o;
            return this.tableId == that.tableId && Objects.equals(this.validWriteIdList, that.validWriteIdList);
        }

        public int hashCode() {
            return Objects.hash(this.validWriteIdList, this.tableId);
        }

        public String toString() {
            return "TableWatermark {" + this.tableId + " @@ " + (this.validWriteIdList != null ? this.validWriteIdList : "null") + "}";
        }
    }

    private static class PartitionNamesWrapper {
        private final List<String> partitionNames;

        private PartitionNamesWrapper(List<String> partitionNames) {
            this.partitionNames = partitionNames;
        }
    }

    protected static class CacheWrapper
    implements CacheI {
        final Cache<CacheKey, Object> c;

        protected CacheWrapper(Cache<CacheKey, Object> c) {
            this.c = c;
        }

        @Override
        public void put(Object k, Object v) {
            this.c.put((Object)((CacheKey)k), v);
        }

        @Override
        public Object get(Object k) {
            return this.c.getIfPresent(k);
        }
    }

    protected static interface CacheI {
        public void put(Object var1, Object var2);

        public Object get(Object var1);
    }
}

