/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.HashSet;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRexExecutorImpl
extends RexExecutorImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HiveRexExecutorImpl.class);

    public HiveRexExecutorImpl() {
        super(null);
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        RexNodeConverter rexNodeConverter = new RexNodeConverter(rexBuilder);
        for (RexNode rexNode : constExps) {
            ExprNodeConverter converter;
            ExprNodeDesc expr = (ExprNodeDesc)rexNode.accept((RexVisitor)(converter = new ExprNodeConverter("", null, null, null, new HashSet<Integer>(), rexBuilder.getTypeFactory())));
            if (expr instanceof ExprNodeGenericFuncDesc) {
                ExprNodeDesc constant = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)expr);
                if (constant != null) {
                    this.addExpressionToList(constant, rexNode, rexNodeConverter, reducedValues);
                    continue;
                }
                reducedValues.add(rexNode);
                continue;
            }
            if (expr instanceof ExprNodeConstantDesc) {
                this.addExpressionToList(expr, rexNode, rexNodeConverter, reducedValues);
                continue;
            }
            reducedValues.add(rexNode);
        }
    }

    private void addExpressionToList(ExprNodeDesc reducedExpr, RexNode originalExpr, RexNodeConverter rexNodeConverter, List<RexNode> reducedValues) {
        try {
            reducedValues.add(rexNodeConverter.convert(reducedExpr));
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            reducedValues.add(originalExpr);
        }
    }
}

