/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.topnkey;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;

public final class CommonKeyPrefix {
    private List<ExprNodeDesc> mappedColumns = new ArrayList<ExprNodeDesc>();
    private StringBuilder mappedOrder = new StringBuilder();
    private StringBuilder mappedNullOrder = new StringBuilder();

    public static CommonKeyPrefix map(TopNKeyDesc topNKeyDesc, GroupByDesc groupByDesc) {
        return CommonKeyPrefix.map(topNKeyDesc.getKeyColumns(), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder(), groupByDesc.getKeys(), groupByDesc.getColumnExprMap(), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder());
    }

    public static CommonKeyPrefix map(TopNKeyDesc topNKeyDesc, ReduceSinkDesc reduceSinkDesc) {
        return CommonKeyPrefix.map(topNKeyDesc.getKeyColumns(), topNKeyDesc.getColumnSortOrder(), topNKeyDesc.getNullOrder(), reduceSinkDesc.getKeyCols(), reduceSinkDesc.getColumnExprMap(), reduceSinkDesc.getOrder(), reduceSinkDesc.getNullOrder());
    }

    public static CommonKeyPrefix map(List<ExprNodeDesc> opKeys, String opOrder, String opNullOrder, List<ExprNodeDesc> parentKeys, Map<String, ExprNodeDesc> parentColExprMap, String parentOrder, String parentNullOrder) {
        if (parentColExprMap == null) {
            return CommonKeyPrefix.map(opKeys, opOrder, opNullOrder, parentKeys, parentOrder, parentNullOrder);
        }
        CommonKeyPrefix commonPrefix = new CommonKeyPrefix();
        int size = Stream.of(opKeys.size(), opOrder.length(), opNullOrder.length(), parentKeys.size(), parentColExprMap.size(), parentOrder.length(), parentNullOrder.length()).min(Integer::compareTo).orElse(0);
        for (int i = 0; i < size; ++i) {
            ExprNodeDesc column = opKeys.get(i);
            String columnName = column.getExprString();
            ExprNodeDesc parentKey = parentKeys.get(i);
            if (parentKey == null || !parentKey.isSame(parentColExprMap.get(columnName)) || opOrder.charAt(i) != parentOrder.charAt(i) || opNullOrder.charAt(i) != parentNullOrder.charAt(i)) {
                return commonPrefix;
            }
            commonPrefix.add(parentKey, opOrder.charAt(i), opNullOrder.charAt(i));
        }
        return commonPrefix;
    }

    public static CommonKeyPrefix map(List<ExprNodeDesc> opKeys, String opOrder, String opNullOrder, List<ExprNodeDesc> parentKeys, String parentOrder, String parentNullOrder) {
        CommonKeyPrefix commonPrefix = new CommonKeyPrefix();
        int size = Stream.of(opKeys.size(), opOrder.length(), opNullOrder.length(), parentKeys.size(), parentOrder.length(), parentNullOrder.length()).min(Integer::compareTo).orElse(0);
        for (int i = 0; i < size; ++i) {
            ExprNodeDesc opKey = opKeys.get(i);
            ExprNodeDesc parentKey = parentKeys.get(i);
            if (opKey == null || !opKey.isSame(parentKey) || opOrder.charAt(i) != parentOrder.charAt(i) || opNullOrder.charAt(i) != parentNullOrder.charAt(i)) {
                return commonPrefix;
            }
            commonPrefix.add(parentKey, opOrder.charAt(i), opNullOrder.charAt(i));
        }
        return commonPrefix;
    }

    private CommonKeyPrefix() {
    }

    public void add(ExprNodeDesc column, char order, char nullOrder) {
        this.mappedColumns.add(column);
        this.mappedOrder.append(order);
        this.mappedNullOrder.append(nullOrder);
    }

    public boolean isEmpty() {
        return this.mappedColumns.isEmpty();
    }

    public List<ExprNodeDesc> getMappedColumns() {
        return this.mappedColumns;
    }

    public String getMappedOrder() {
        return this.mappedOrder.toString();
    }

    public String getMappedNullOrder() {
        return this.mappedNullOrder.toString();
    }

    public int size() {
        return this.mappedColumns.size();
    }
}

