/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class DropTableHandler
extends AbstractEventHandler<DropTableMessage> {
    DropTableHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    DropTableMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getDropTableMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} DROP_TABLE message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        if (withinContext.removeFromListOfTablesForBootstrap(this.event.getTableName())) {
            LOG.info("Table " + this.event.getTableName() + " is removed from list of tables to be bootstrapped.");
            return;
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_DROP_TABLE;
    }
}

