/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.rename.AlterTableRenameDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class RenameTableHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        AlterTableMessage msg = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
        try {
            Table tableObjBefore = msg.getTableObjBefore();
            Table tableObjAfter = msg.getTableObjAfter();
            String oldDbName = tableObjBefore.getDbName();
            String newDbName = tableObjAfter.getDbName();
            if (!context.isDbNameEmpty()) {
                if (!oldDbName.equalsIgnoreCase(newDbName)) {
                    throw new SemanticException("Cannot replicate an event renaming a table across databases into a db level load " + oldDbName + "->" + newDbName);
                }
                oldDbName = context.dbName;
                newDbName = context.dbName;
            }
            TableName oldName = TableName.fromString((String)tableObjBefore.getTableName(), null, (String)oldDbName);
            TableName newName = TableName.fromString((String)tableObjAfter.getTableName(), null, (String)newDbName);
            ReplicationSpec replicationSpec = context.eventOnlyReplicationSpec();
            AlterTableRenameDesc renameTableDesc = new AlterTableRenameDesc(oldName, replicationSpec, false, newName.getNotEmptyDbTable());
            renameTableDesc.setWriteId(msg.getWriteId());
            Task<DDLWork> renameTableTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, renameTableDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
            context.log.debug("Added rename table task : {}:{}->{}", new Object[]{renameTableTask.getId(), oldName.getNotEmptyDbTable(), newName.getNotEmptyDbTable()});
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), newDbName, tableObjAfter.getTableName(), null);
            return ReplUtils.addChildTask(renameTableTask);
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)((Object)e) : new SemanticException("Error reading message members", (Throwable)e);
        }
    }
}

