/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;

@Explain(displayName="Select Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class SelectDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private List<ExprNodeDesc> colList;
    private List<String> outputColumnNames;
    private boolean selectStar;
    private boolean selStarNoCompute;

    public SelectDesc() {
    }

    public SelectDesc(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }

    public SelectDesc(List<ExprNodeDesc> colList, List<String> outputColumnNames) {
        this(colList, outputColumnNames, false);
    }

    public SelectDesc(List<ExprNodeDesc> colList, List<String> outputColumnNames, boolean selectStar) {
        this.colList = colList;
        this.selectStar = selectStar;
        this.outputColumnNames = outputColumnNames;
    }

    @Override
    public Object clone() {
        SelectDesc ret = new SelectDesc();
        ret.setColList((List<ExprNodeDesc>)(this.getColList() == null ? null : new ArrayList<ExprNodeDesc>(this.getColList())));
        ret.setOutputColumnNames((List<String>)(this.getOutputColumnNames() == null ? null : new ArrayList<String>(this.getOutputColumnNames())));
        ret.setSelectStar(this.selectStar);
        ret.setSelStarNoCompute(this.selStarNoCompute);
        return ret;
    }

    @Signature
    @Explain(displayName="expressions")
    public String getColListString() {
        return PlanUtils.getExprListString(this.colList);
    }

    public List<ExprNodeDesc> getColList() {
        return this.colList;
    }

    public void setColList(List<ExprNodeDesc> colList) {
        this.colList = colList;
    }

    @Signature
    @Explain(displayName="outputColumnNames")
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public List<String> getUserLevelExplainOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    @Signature
    @Explain(displayName="SELECT * ")
    public String explainNoCompute() {
        if (this.isSelStarNoCompute()) {
            return "(no compute)";
        }
        return null;
    }

    public boolean isSelectStar() {
        return this.selectStar;
    }

    public void setSelectStar(boolean selectStar) {
        this.selectStar = selectStar;
    }

    public boolean isSelStarNoCompute() {
        return this.selStarNoCompute;
    }

    public void setSelStarNoCompute(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Select Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public SelectOperatorExplainVectorization getSelectVectorization() {
        VectorSelectDesc vectorSelectDesc = (VectorSelectDesc)this.getVectorDesc();
        if (vectorSelectDesc == null) {
            return null;
        }
        return new SelectOperatorExplainVectorization(this, vectorSelectDesc);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            SelectDesc otherDesc = (SelectDesc)other;
            return Objects.equals(this.getColListString(), otherDesc.getColListString()) && Objects.equals(this.getOutputColumnNames(), otherDesc.getOutputColumnNames()) && Objects.equals(this.explainNoCompute(), otherDesc.explainNoCompute());
        }
        return false;
    }

    public class SelectOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final SelectDesc selectDesc;
        private final VectorSelectDesc vectorSelectDesc;

        public SelectOperatorExplainVectorization(SelectDesc selectDesc, VectorSelectDesc vectorSelectDesc) {
            super(vectorSelectDesc, true);
            this.selectDesc = selectDesc;
            this.vectorSelectDesc = vectorSelectDesc;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="selectExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getSelectExpressions() {
            return this.vectorExpressionsToStringList(this.vectorSelectDesc.getSelectExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="projectedOutputColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProjectedOutputColumnNums() {
            return Arrays.toString(this.vectorSelectDesc.getProjectedOutputColumns());
        }
    }
}

