/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.ppd.OpProcFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprWalkerInfo
implements NodeProcessorCtx {
    protected static final Logger LOG = LoggerFactory.getLogger((String)OpProcFactory.class.getName());
    private Operator<? extends OperatorDesc> op = null;
    private final Map<String, List<ExprNodeDesc>> pushdownPreds;
    private final Map<String, List<ExprNodeDesc>> nonFinalPreds;
    private final Map<ExprNodeDesc, ExprInfo> exprInfoMap;
    private final Map<ExprNodeDesc, ExprNodeDesc> newToOldExprMap;
    private boolean isDeterministic = true;

    public ExprWalkerInfo() {
        this.pushdownPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.nonFinalPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.exprInfoMap = new IdentityHashMap<ExprNodeDesc, ExprInfo>();
        this.newToOldExprMap = new IdentityHashMap<ExprNodeDesc, ExprNodeDesc>();
    }

    public ExprWalkerInfo(Operator<? extends OperatorDesc> op) {
        this.op = op;
        this.pushdownPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.exprInfoMap = new IdentityHashMap<ExprNodeDesc, ExprInfo>();
        this.nonFinalPreds = new HashMap<String, List<ExprNodeDesc>>();
        this.newToOldExprMap = new IdentityHashMap<ExprNodeDesc, ExprNodeDesc>();
    }

    public Operator<? extends OperatorDesc> getOp() {
        return this.op;
    }

    public Map<ExprNodeDesc, ExprNodeDesc> getNewToOldExprMap() {
        return this.newToOldExprMap;
    }

    public ExprInfo getExprInfo(ExprNodeDesc expr) {
        return this.exprInfoMap.get(expr);
    }

    public ExprInfo addExprInfo(ExprNodeDesc expr) {
        ExprInfo exprInfo = new ExprInfo();
        this.exprInfoMap.put(expr, exprInfo);
        return exprInfo;
    }

    public ExprInfo addOrGetExprInfo(ExprNodeDesc expr) {
        ExprInfo exprInfo = this.exprInfoMap.get(expr);
        if (exprInfo == null) {
            exprInfo = new ExprInfo();
            this.exprInfoMap.put(expr, exprInfo);
        }
        return exprInfo;
    }

    public void addFinalCandidate(String alias, ExprNodeDesc expr) {
        List<ExprNodeDesc> predicates = this.getPushdownPreds(alias);
        for (ExprNodeDesc curPred : predicates) {
            if (!curPred.isSame(expr)) continue;
            return;
        }
        predicates.add(expr);
    }

    public void addPushDowns(String alias, List<ExprNodeDesc> pushDowns) {
        List<ExprNodeDesc> predicates = this.getPushdownPreds(alias);
        for (ExprNodeDesc newPred : pushDowns) {
            boolean isNew = true;
            for (ExprNodeDesc curPred : predicates) {
                if (!curPred.isSame(newPred)) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            predicates.add(newPred);
        }
    }

    public Map<String, List<ExprNodeDesc>> getFinalCandidates() {
        return this.pushdownPreds;
    }

    private List<ExprNodeDesc> getPushdownPreds(String alias) {
        List<ExprNodeDesc> predicates = this.pushdownPreds.get(alias);
        if (predicates == null) {
            predicates = new ArrayList<ExprNodeDesc>();
            this.pushdownPreds.put(alias, predicates);
        }
        return predicates;
    }

    public boolean hasAnyCandidates() {
        if (this.pushdownPreds == null || this.pushdownPreds.isEmpty()) {
            return false;
        }
        for (List<ExprNodeDesc> exprs : this.pushdownPreds.values()) {
            if (exprs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonFinalCandidates() {
        if (this.nonFinalPreds == null || this.nonFinalPreds.isEmpty()) {
            return false;
        }
        for (List<ExprNodeDesc> exprs : this.nonFinalPreds.values()) {
            if (exprs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addNonFinalCandidate(String alias, ExprNodeDesc expr) {
        if (this.nonFinalPreds.get(alias) == null) {
            this.nonFinalPreds.put(alias, new ArrayList());
        }
        this.nonFinalPreds.get(alias).add(expr);
    }

    public Map<String, List<ExprNodeDesc>> getNonFinalCandidates() {
        return this.nonFinalPreds;
    }

    public Map<String, List<ExprNodeDesc>> getResidualPredicates(boolean clear) {
        HashMap<String, List<ExprNodeDesc>> oldExprs = new HashMap<String, List<ExprNodeDesc>>();
        for (Map.Entry<String, List<ExprNodeDesc>> entry : this.nonFinalPreds.entrySet()) {
            ArrayList<ExprNodeDesc> converted = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc newExpr : entry.getValue()) {
                converted.add(this.newToOldExprMap.get(newExpr).clone());
            }
            oldExprs.put(entry.getKey(), converted);
        }
        if (clear) {
            this.nonFinalPreds.clear();
        }
        return oldExprs;
    }

    public void merge(ExprWalkerInfo ewi) {
        List<ExprNodeDesc> predList;
        if (ewi == null) {
            return;
        }
        for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
            predList = this.pushdownPreds.get(e.getKey());
            if (predList != null) {
                predList.addAll((Collection<ExprNodeDesc>)e.getValue());
                continue;
            }
            this.pushdownPreds.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getNonFinalCandidates().entrySet()) {
            predList = this.nonFinalPreds.get(e.getKey());
            if (predList != null) {
                predList.addAll((Collection<ExprNodeDesc>)e.getValue());
                continue;
            }
            this.nonFinalPreds.put(e.getKey(), e.getValue());
        }
        this.newToOldExprMap.putAll(ewi.getNewToOldExprMap());
    }

    public void setDeterministic(boolean b) {
        this.isDeterministic = b;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    protected class ExprInfo {
        protected boolean isCandidate = false;
        protected String alias = null;
        protected ExprNodeDesc convertedExpr = null;

        protected ExprInfo() {
        }
    }
}

