/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCoshDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCoshLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="cosh", value="_FUNC_(x) - returns the hyperbolic cosine of x (x is in radians)", extended="Example:\n   > SELECT _FUNC_(0) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncCoshDoubleToDouble.class, FuncCoshLongToDouble.class})
public class UDFCosh
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(StrictMath.cosh(a.get()));
        return this.result;
    }
}

