/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPolygon;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryAccessor;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_NumInteriorRing", value="_FUNC_(ST_Polygon) - return the number of interior rings in the polygon", extended="Example:\n  SELECT _FUNC_(ST_Polygon(1,1, 1,4, 4,1)) FROM src LIMIT 1;  -- 0\n  SELECT _FUNC_(ST_Polygon('polygon ((0 0, 8 0, 0 8, 0 0), (1 1, 1 5, 5 1, 1 1))')) FROM src LIMIT 1;  -- 1\n")
public class ST_NumInteriorRing
extends ST_GeometryAccessor {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_NumInteriorRing.class.getName());
    final IntWritable resultInt = new IntWritable();

    public IntWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        if (GeometryUtils.getType(geomref) == GeometryUtils.OGCType.ST_POLYGON) {
            try {
                this.resultInt.set(((OGCPolygon)ogcGeometry).numInteriorRing());
                return this.resultInt;
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_NumInteriorRing: " + e);
                return null;
            }
        }
        LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POLYGON, GeometryUtils.getType(geomref));
        return null;
    }
}

