/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@UDFType(deterministic=false)
@Description(name="sq_count_check", value="_FUNC_(x) - Internal check on scalar subquery expression to make sure atmost one row is returned", extended="For internal use only")
public class GenericUDFSQCountCheck
extends GenericUDF {
    private final BooleanWritable resultBool = new BooleanWritable();
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length > 2) {
            throw new UDFArgumentLengthException("Invalid scalar subquery expression. Subquery count check expected two argument but received: " + arguments.length);
        }
        this.checkArgPrimitive(arguments, 0);
        this.converters[0] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        switch (arguments.length) {
            case 1: {
                if (this.getLongValue(arguments, 0, this.converters) <= 1L) break;
                throw new UDFArgumentException(" Scalar subquery expression returns more than one row.");
            }
            case 2: {
                Object valObject = arguments[0].get();
                if (valObject != null && this.getLongValue(arguments, 0, this.converters) == 0L) {
                    throw new UDFArgumentException(" IN/NOT IN subquery with aggregate returning zero result. Currently this is not supported.");
                }
                if (valObject != null) break;
                throw new UDFArgumentException(" IN/NOT IN subquery with aggregate returning zero result. Currently this is not supported.");
            }
        }
        this.resultBool.set(true);
        return this.resultBool;
    }

    @Override
    protected String getFuncName() {
        return "sq_count_check";
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

